/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComponentsResponse extends ProtonResponse implements
        ToCopyableBuilder<ListComponentsResponse.Builder, ListComponentsResponse> {
    private static final SdkField<List<ComponentSummary>> COMPONENTS_FIELD = SdkField
            .<List<ComponentSummary>> builder(MarshallingType.LIST)
            .memberName("components")
            .getter(getter(ListComponentsResponse::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListComponentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ComponentSummary> components;

    private final String nextToken;

    private ListComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.components = builder.components;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Components property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of components with summary data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponents} method.
     * </p>
     * 
     * @return An array of components with summary data.
     */
    public final List<ComponentSummary> components() {
        return components;
    }

    /**
     * <p>
     * A token that indicates the location of the next component in the array of components, after the current requested
     * list of components.
     * </p>
     * 
     * @return A token that indicates the location of the next component in the array of components, after the current
     *         requested list of components.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentsResponse)) {
            return false;
        }
        ListComponentsResponse other = (ListComponentsResponse) obj;
        return hasComponents() == other.hasComponents() && Objects.equals(components(), other.components())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComponentsResponse").add("Components", hasComponents() ? components() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentsResponse, T> g) {
        return obj -> g.apply((ListComponentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListComponentsResponse> {
        /**
         * <p>
         * An array of components with summary data.
         * </p>
         * 
         * @param components
         *        An array of components with summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<ComponentSummary> components);

        /**
         * <p>
         * An array of components with summary data.
         * </p>
         * 
         * @param components
         *        An array of components with summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(ComponentSummary... components);

        /**
         * <p>
         * An array of components with summary data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.ComponentSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.proton.model.ComponentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.ComponentSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #components(List<ComponentSummary>)}.
         * 
         * @param components
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.ComponentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(java.util.Collection<ComponentSummary>)
         */
        Builder components(Consumer<ComponentSummary.Builder>... components);

        /**
         * <p>
         * A token that indicates the location of the next component in the array of components, after the current
         * requested list of components.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next component in the array of components, after the
         *        current requested list of components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private List<ComponentSummary> components = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentsResponse model) {
            super(model);
            components(model.components);
            nextToken(model.nextToken);
        }

        public final List<ComponentSummary.Builder> getComponents() {
            List<ComponentSummary.Builder> result = ComponentSummaryListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<ComponentSummary.BuilderImpl> components) {
            this.components = ComponentSummaryListCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Collection<ComponentSummary> components) {
            this.components = ComponentSummaryListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(ComponentSummary... components) {
            components(Arrays.asList(components));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(Consumer<ComponentSummary.Builder>... components) {
            components(Stream.of(components).map(c -> ComponentSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComponentsResponse build() {
            return new ListComponentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
