/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEnvironmentTemplateVersionRequest extends ProtonRequest implements
        ToCopyableBuilder<DeleteEnvironmentTemplateVersionRequest.Builder, DeleteEnvironmentTemplateVersionRequest> {
    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("majorVersion").getter(getter(DeleteEnvironmentTemplateVersionRequest::majorVersion))
            .setter(setter(Builder::majorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()).build();

    private static final SdkField<String> MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("minorVersion").getter(getter(DeleteEnvironmentTemplateVersionRequest::minorVersion))
            .setter(setter(Builder::minorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minorVersion").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(DeleteEnvironmentTemplateVersionRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAJOR_VERSION_FIELD,
            MINOR_VERSION_FIELD, TEMPLATE_NAME_FIELD));

    private final String majorVersion;

    private final String minorVersion;

    private final String templateName;

    private DeleteEnvironmentTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.majorVersion = builder.majorVersion;
        this.minorVersion = builder.minorVersion;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * The environment template major version to delete.
     * </p>
     * 
     * @return The environment template major version to delete.
     */
    public final String majorVersion() {
        return majorVersion;
    }

    /**
     * <p>
     * The environment template minor version to delete.
     * </p>
     * 
     * @return The environment template minor version to delete.
     */
    public final String minorVersion() {
        return minorVersion;
    }

    /**
     * <p>
     * The name of the environment template.
     * </p>
     * 
     * @return The name of the environment template.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEnvironmentTemplateVersionRequest)) {
            return false;
        }
        DeleteEnvironmentTemplateVersionRequest other = (DeleteEnvironmentTemplateVersionRequest) obj;
        return Objects.equals(majorVersion(), other.majorVersion()) && Objects.equals(minorVersion(), other.minorVersion())
                && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEnvironmentTemplateVersionRequest").add("MajorVersion", majorVersion())
                .add("MinorVersion", minorVersion()).add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "majorVersion":
            return Optional.ofNullable(clazz.cast(majorVersion()));
        case "minorVersion":
            return Optional.ofNullable(clazz.cast(minorVersion()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEnvironmentTemplateVersionRequest, T> g) {
        return obj -> g.apply((DeleteEnvironmentTemplateVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteEnvironmentTemplateVersionRequest> {
        /**
         * <p>
         * The environment template major version to delete.
         * </p>
         * 
         * @param majorVersion
         *        The environment template major version to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorVersion(String majorVersion);

        /**
         * <p>
         * The environment template minor version to delete.
         * </p>
         * 
         * @param minorVersion
         *        The environment template minor version to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minorVersion(String minorVersion);

        /**
         * <p>
         * The name of the environment template.
         * </p>
         * 
         * @param templateName
         *        The name of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String majorVersion;

        private String minorVersion;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEnvironmentTemplateVersionRequest model) {
            super(model);
            majorVersion(model.majorVersion);
            minorVersion(model.minorVersion);
            templateName(model.templateName);
        }

        public final String getMajorVersion() {
            return majorVersion;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final String getMinorVersion() {
            return minorVersion;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        @Override
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEnvironmentTemplateVersionRequest build() {
            return new DeleteEnvironmentTemplateVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
