/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceInstanceRequest extends ProtonRequest implements
        ToCopyableBuilder<CreateServiceInstanceRequest.Builder, CreateServiceInstanceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateServiceInstanceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateServiceInstanceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(CreateServiceInstanceRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("spec")
            .getter(getter(CreateServiceInstanceRequest::spec)).setter(setter(Builder::spec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateServiceInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMajorVersion").getter(getter(CreateServiceInstanceRequest::templateMajorVersion))
            .setter(setter(Builder::templateMajorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMinorVersion").getter(getter(CreateServiceInstanceRequest::templateMinorVersion))
            .setter(setter(Builder::templateMinorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NAME_FIELD, SERVICE_NAME_FIELD, SPEC_FIELD, TAGS_FIELD, TEMPLATE_MAJOR_VERSION_FIELD, TEMPLATE_MINOR_VERSION_FIELD));

    private final String clientToken;

    private final String name;

    private final String serviceName;

    private final String spec;

    private final List<Tag> tags;

    private final String templateMajorVersion;

    private final String templateMinorVersion;

    private CreateServiceInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.serviceName = builder.serviceName;
        this.spec = builder.spec;
        this.tags = builder.tags;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
    }

    /**
     * <p>
     * The client token of the service instance to create.
     * </p>
     * 
     * @return The client token of the service instance to create.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the service instance to create.
     * </p>
     * 
     * @return The name of the service instance to create.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the service the service instance is added to.
     * </p>
     * 
     * @return The name of the service the service instance is added to.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The spec for the service instance you want to create.
     * </p>
     * 
     * @return The spec for the service instance you want to create.
     */
    public final String spec() {
        return spec;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of metadata items that you can associate with the Proton service instance. A tag is a key-value
     * pair.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
     * resources and tagging</a> in the <i>Proton User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of metadata items that you can associate with the Proton service instance. A tag is a
     *         key-value pair.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
     *         tagging</a> in the <i>Proton User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * To create a new major and minor version of the service template, <i>exclude</i> <code>major Version</code>.
     * </p>
     * 
     * @return To create a new major and minor version of the service template, <i>exclude</i>
     *         <code>major Version</code>.
     */
    public final String templateMajorVersion() {
        return templateMajorVersion;
    }

    /**
     * <p>
     * To create a new minor version of the service template, include a <code>major Version</code>.
     * </p>
     * 
     * @return To create a new minor version of the service template, include a <code>major Version</code>.
     */
    public final String templateMinorVersion() {
        return templateMinorVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateMinorVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceInstanceRequest)) {
            return false;
        }
        CreateServiceInstanceRequest other = (CreateServiceInstanceRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(name(), other.name())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(spec(), other.spec())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(templateMajorVersion(), other.templateMajorVersion())
                && Objects.equals(templateMinorVersion(), other.templateMinorVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceInstanceRequest").add("ClientToken", clientToken()).add("Name", name())
                .add("ServiceName", serviceName()).add("Spec", spec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null).add("TemplateMajorVersion", templateMajorVersion())
                .add("TemplateMinorVersion", templateMinorVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "templateMajorVersion":
            return Optional.ofNullable(clazz.cast(templateMajorVersion()));
        case "templateMinorVersion":
            return Optional.ofNullable(clazz.cast(templateMinorVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceInstanceRequest, T> g) {
        return obj -> g.apply((CreateServiceInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceInstanceRequest> {
        /**
         * <p>
         * The client token of the service instance to create.
         * </p>
         * 
         * @param clientToken
         *        The client token of the service instance to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the service instance to create.
         * </p>
         * 
         * @param name
         *        The name of the service instance to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the service the service instance is added to.
         * </p>
         * 
         * @param serviceName
         *        The name of the service the service instance is added to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The spec for the service instance you want to create.
         * </p>
         * 
         * @param spec
         *        The spec for the service instance you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(String spec);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton service instance. A tag is a
         * key-value pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton service instance. A tag is a
         *        key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton service instance. A tag is a
         * key-value pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton service instance. A tag is a
         *        key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton service instance. A tag is a
         * key-value pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.proton.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.proton.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.proton.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * To create a new major and minor version of the service template, <i>exclude</i> <code>major Version</code>.
         * </p>
         * 
         * @param templateMajorVersion
         *        To create a new major and minor version of the service template, <i>exclude</i>
         *        <code>major Version</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMajorVersion(String templateMajorVersion);

        /**
         * <p>
         * To create a new minor version of the service template, include a <code>major Version</code>.
         * </p>
         * 
         * @param templateMinorVersion
         *        To create a new minor version of the service template, include a <code>major Version</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMinorVersion(String templateMinorVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String name;

        private String serviceName;

        private String spec;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String templateMajorVersion;

        private String templateMinorVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceInstanceRequest model) {
            super(model);
            clientToken(model.clientToken);
            name(model.name);
            serviceName(model.serviceName);
            spec(model.spec);
            tags(model.tags);
            templateMajorVersion(model.templateMajorVersion);
            templateMinorVersion(model.templateMinorVersion);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getSpec() {
            return spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateMajorVersion() {
            return templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceInstanceRequest build() {
            return new CreateServiceInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
