/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.ComponentSummary;
import software.amazon.awssdk.services.proton.model.ListComponentsRequest;
import software.amazon.awssdk.services.proton.model.ListComponentsResponse;

public class ListComponentsIterable
implements SdkIterable<ListComponentsResponse> {
    private final ProtonClient client;
    private final ListComponentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComponentsIterable(ProtonClient client, ListComponentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListComponentsResponseFetcher();
    }

    public Iterator<ListComponentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComponentSummary> components() {
        Function<ListComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.components() != null) {
                return response.components().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComponentsResponseFetcher
    implements SyncPageFetcher<ListComponentsResponse> {
        private ListComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComponentsResponse nextPage(ListComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListComponentsIterable.this.client.listComponents(ListComponentsIterable.this.firstRequest);
            }
            return ListComponentsIterable.this.client.listComponents((ListComponentsRequest)((Object)ListComponentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

