/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.AccessDeniedException;
import software.amazon.awssdk.services.proton.model.CancelComponentDeploymentRequest;
import software.amazon.awssdk.services.proton.model.CancelComponentDeploymentResponse;
import software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentRequest;
import software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentResponse;
import software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentRequest;
import software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentResponse;
import software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentRequest;
import software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentResponse;
import software.amazon.awssdk.services.proton.model.ConflictException;
import software.amazon.awssdk.services.proton.model.CreateComponentRequest;
import software.amazon.awssdk.services.proton.model.CreateComponentResponse;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateRequest;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateResponse;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.proton.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.proton.model.CreateServiceRequest;
import software.amazon.awssdk.services.proton.model.CreateServiceResponse;
import software.amazon.awssdk.services.proton.model.CreateServiceTemplateRequest;
import software.amazon.awssdk.services.proton.model.CreateServiceTemplateResponse;
import software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.DeleteComponentRequest;
import software.amazon.awssdk.services.proton.model.DeleteComponentResponse;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateRequest;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateResponse;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.proton.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.proton.model.DeleteServiceRequest;
import software.amazon.awssdk.services.proton.model.DeleteServiceResponse;
import software.amazon.awssdk.services.proton.model.DeleteServiceTemplateRequest;
import software.amazon.awssdk.services.proton.model.DeleteServiceTemplateResponse;
import software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.proton.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.proton.model.GetComponentRequest;
import software.amazon.awssdk.services.proton.model.GetComponentResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.GetRepositoryRequest;
import software.amazon.awssdk.services.proton.model.GetRepositoryResponse;
import software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusRequest;
import software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusResponse;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceResponse;
import software.amazon.awssdk.services.proton.model.GetServiceRequest;
import software.amazon.awssdk.services.proton.model.GetServiceResponse;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateRequest;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateResponse;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusRequest;
import software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusResponse;
import software.amazon.awssdk.services.proton.model.InternalServerException;
import software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse;
import software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ListComponentsRequest;
import software.amazon.awssdk.services.proton.model.ListComponentsResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse;
import software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.proton.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.proton.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest;
import software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse;
import software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsResponse;
import software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest;
import software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse;
import software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse;
import software.amazon.awssdk.services.proton.model.ListServicesRequest;
import software.amazon.awssdk.services.proton.model.ListServicesResponse;
import software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.proton.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest;
import software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeResponse;
import software.amazon.awssdk.services.proton.model.ProtonException;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.ResourceNotFoundException;
import software.amazon.awssdk.services.proton.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.proton.model.TagResourceRequest;
import software.amazon.awssdk.services.proton.model.TagResourceResponse;
import software.amazon.awssdk.services.proton.model.ThrottlingException;
import software.amazon.awssdk.services.proton.model.UntagResourceRequest;
import software.amazon.awssdk.services.proton.model.UntagResourceResponse;
import software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.proton.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.proton.model.UpdateComponentRequest;
import software.amazon.awssdk.services.proton.model.UpdateComponentResponse;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionResponse;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateResponse;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceInstanceRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceInstanceResponse;
import software.amazon.awssdk.services.proton.model.UpdateServicePipelineRequest;
import software.amazon.awssdk.services.proton.model.UpdateServicePipelineResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceTemplateRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceTemplateResponse;
import software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigRequest;
import software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigResponse;
import software.amazon.awssdk.services.proton.model.ValidationException;
import software.amazon.awssdk.services.proton.paginators.ListComponentOutputsIterable;
import software.amazon.awssdk.services.proton.paginators.ListComponentProvisionedResourcesIterable;
import software.amazon.awssdk.services.proton.paginators.ListComponentsIterable;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentAccountConnectionsIterable;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentOutputsIterable;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentProvisionedResourcesIterable;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplateVersionsIterable;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentTemplatesIterable;
import software.amazon.awssdk.services.proton.paginators.ListEnvironmentsIterable;
import software.amazon.awssdk.services.proton.paginators.ListRepositoriesIterable;
import software.amazon.awssdk.services.proton.paginators.ListRepositorySyncDefinitionsIterable;
import software.amazon.awssdk.services.proton.paginators.ListServiceInstanceOutputsIterable;
import software.amazon.awssdk.services.proton.paginators.ListServiceInstanceProvisionedResourcesIterable;
import software.amazon.awssdk.services.proton.paginators.ListServiceInstancesIterable;
import software.amazon.awssdk.services.proton.paginators.ListServicePipelineOutputsIterable;
import software.amazon.awssdk.services.proton.paginators.ListServicePipelineProvisionedResourcesIterable;
import software.amazon.awssdk.services.proton.paginators.ListServiceTemplateVersionsIterable;
import software.amazon.awssdk.services.proton.paginators.ListServiceTemplatesIterable;
import software.amazon.awssdk.services.proton.paginators.ListServicesIterable;
import software.amazon.awssdk.services.proton.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.proton.transform.AcceptEnvironmentAccountConnectionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CancelComponentDeploymentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CancelEnvironmentDeploymentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CancelServiceInstanceDeploymentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CancelServicePipelineDeploymentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateComponentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateEnvironmentAccountConnectionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateEnvironmentTemplateRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateEnvironmentTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateServiceRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateServiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateServiceTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.CreateTemplateSyncConfigRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteComponentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteEnvironmentAccountConnectionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteEnvironmentTemplateRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteEnvironmentTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteServiceRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteServiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteServiceTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.DeleteTemplateSyncConfigRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetComponentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetEnvironmentAccountConnectionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetEnvironmentTemplateRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetEnvironmentTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetRepositoryRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetRepositorySyncStatusRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetServiceInstanceRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetServiceRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetServiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetServiceTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetTemplateSyncConfigRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.GetTemplateSyncStatusRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListComponentOutputsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListComponentProvisionedResourcesRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListComponentsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListEnvironmentAccountConnectionsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListEnvironmentOutputsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListEnvironmentProvisionedResourcesRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListEnvironmentTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListEnvironmentTemplatesRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListRepositorySyncDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListServiceInstanceOutputsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListServiceInstanceProvisionedResourcesRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListServiceInstancesRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListServicePipelineOutputsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListServicePipelineProvisionedResourcesRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListServiceTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListServiceTemplatesRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.NotifyResourceDeploymentStatusChangeRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.RejectEnvironmentAccountConnectionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateComponentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateEnvironmentAccountConnectionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateEnvironmentTemplateRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateEnvironmentTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateServiceInstanceRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateServicePipelineRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateServiceRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateServiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateServiceTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.proton.transform.UpdateTemplateSyncConfigRequestMarshaller;
import software.amazon.awssdk.services.proton.waiters.ProtonWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultProtonClient
implements ProtonClient {
    private static final Logger log = Logger.loggerFor(DefaultProtonClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultProtonClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "proton";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptEnvironmentAccountConnectionResponse acceptEnvironmentAccountConnection(AcceptEnvironmentAccountConnectionRequest acceptEnvironmentAccountConnectionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptEnvironmentAccountConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, acceptEnvironmentAccountConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptEnvironmentAccountConnection");
            AcceptEnvironmentAccountConnectionResponse acceptEnvironmentAccountConnectionResponse = (AcceptEnvironmentAccountConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptEnvironmentAccountConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptEnvironmentAccountConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptEnvironmentAccountConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptEnvironmentAccountConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$acceptEnvironmentAccountConnection$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelComponentDeploymentResponse cancelComponentDeployment(CancelComponentDeploymentRequest cancelComponentDeploymentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelComponentDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, cancelComponentDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelComponentDeployment");
            CancelComponentDeploymentResponse cancelComponentDeploymentResponse = (CancelComponentDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelComponentDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelComponentDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelComponentDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelComponentDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$cancelComponentDeployment$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelEnvironmentDeploymentResponse cancelEnvironmentDeployment(CancelEnvironmentDeploymentRequest cancelEnvironmentDeploymentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelEnvironmentDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, cancelEnvironmentDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelEnvironmentDeployment");
            CancelEnvironmentDeploymentResponse cancelEnvironmentDeploymentResponse = (CancelEnvironmentDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelEnvironmentDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelEnvironmentDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelEnvironmentDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelEnvironmentDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$cancelEnvironmentDeployment$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelServiceInstanceDeploymentResponse cancelServiceInstanceDeployment(CancelServiceInstanceDeploymentRequest cancelServiceInstanceDeploymentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelServiceInstanceDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, cancelServiceInstanceDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelServiceInstanceDeployment");
            CancelServiceInstanceDeploymentResponse cancelServiceInstanceDeploymentResponse = (CancelServiceInstanceDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelServiceInstanceDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelServiceInstanceDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelServiceInstanceDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelServiceInstanceDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$cancelServiceInstanceDeployment$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelServicePipelineDeploymentResponse cancelServicePipelineDeployment(CancelServicePipelineDeploymentRequest cancelServicePipelineDeploymentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelServicePipelineDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, cancelServicePipelineDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelServicePipelineDeployment");
            CancelServicePipelineDeploymentResponse cancelServicePipelineDeploymentResponse = (CancelServicePipelineDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelServicePipelineDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelServicePipelineDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelServicePipelineDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelServicePipelineDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$cancelServicePipelineDeployment$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateComponentResponse createComponent(CreateComponentRequest createComponentRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateComponentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createComponentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateComponent");
            CreateComponentResponse createComponentResponse = (CreateComponentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateComponent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createComponentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateComponentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createComponentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createComponent$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEnvironment");
            CreateEnvironmentResponse createEnvironmentResponse = (CreateEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createEnvironment$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEnvironmentAccountConnectionResponse createEnvironmentAccountConnection(CreateEnvironmentAccountConnectionRequest createEnvironmentAccountConnectionRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEnvironmentAccountConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createEnvironmentAccountConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEnvironmentAccountConnection");
            CreateEnvironmentAccountConnectionResponse createEnvironmentAccountConnectionResponse = (CreateEnvironmentAccountConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEnvironmentAccountConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEnvironmentAccountConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEnvironmentAccountConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEnvironmentAccountConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createEnvironmentAccountConnection$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEnvironmentTemplateResponse createEnvironmentTemplate(CreateEnvironmentTemplateRequest createEnvironmentTemplateRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEnvironmentTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createEnvironmentTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEnvironmentTemplate");
            CreateEnvironmentTemplateResponse createEnvironmentTemplateResponse = (CreateEnvironmentTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEnvironmentTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEnvironmentTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEnvironmentTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEnvironmentTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createEnvironmentTemplate$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEnvironmentTemplateVersionResponse createEnvironmentTemplateVersion(CreateEnvironmentTemplateVersionRequest createEnvironmentTemplateVersionRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEnvironmentTemplateVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createEnvironmentTemplateVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEnvironmentTemplateVersion");
            CreateEnvironmentTemplateVersionResponse createEnvironmentTemplateVersionResponse = (CreateEnvironmentTemplateVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEnvironmentTemplateVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEnvironmentTemplateVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEnvironmentTemplateVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEnvironmentTemplateVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createEnvironmentTemplateVersion$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRepository");
            CreateRepositoryResponse createRepositoryResponse = (CreateRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRepositoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRepositoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createRepository$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServiceResponse createService(CreateServiceRequest createServiceRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateService");
            CreateServiceResponse createServiceResponse = (CreateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createService$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServiceTemplateResponse createServiceTemplate(CreateServiceTemplateRequest createServiceTemplateRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServiceTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createServiceTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateServiceTemplate");
            CreateServiceTemplateResponse createServiceTemplateResponse = (CreateServiceTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateServiceTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createServiceTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateServiceTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createServiceTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createServiceTemplate$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServiceTemplateVersionResponse createServiceTemplateVersion(CreateServiceTemplateVersionRequest createServiceTemplateVersionRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServiceTemplateVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createServiceTemplateVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateServiceTemplateVersion");
            CreateServiceTemplateVersionResponse createServiceTemplateVersionResponse = (CreateServiceTemplateVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateServiceTemplateVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createServiceTemplateVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateServiceTemplateVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createServiceTemplateVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createServiceTemplateVersion$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTemplateSyncConfigResponse createTemplateSyncConfig(CreateTemplateSyncConfigRequest createTemplateSyncConfigRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTemplateSyncConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, createTemplateSyncConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTemplateSyncConfig");
            CreateTemplateSyncConfigResponse createTemplateSyncConfigResponse = (CreateTemplateSyncConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTemplateSyncConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTemplateSyncConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTemplateSyncConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTemplateSyncConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$createTemplateSyncConfig$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteComponentResponse deleteComponent(DeleteComponentRequest deleteComponentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteComponentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteComponentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteComponent");
            DeleteComponentResponse deleteComponentResponse = (DeleteComponentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteComponent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteComponentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteComponentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteComponentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteComponent$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEnvironmentResponse deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEnvironment");
            DeleteEnvironmentResponse deleteEnvironmentResponse = (DeleteEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteEnvironment$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEnvironmentAccountConnectionResponse deleteEnvironmentAccountConnection(DeleteEnvironmentAccountConnectionRequest deleteEnvironmentAccountConnectionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEnvironmentAccountConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteEnvironmentAccountConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEnvironmentAccountConnection");
            DeleteEnvironmentAccountConnectionResponse deleteEnvironmentAccountConnectionResponse = (DeleteEnvironmentAccountConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEnvironmentAccountConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEnvironmentAccountConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEnvironmentAccountConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEnvironmentAccountConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteEnvironmentAccountConnection$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEnvironmentTemplateResponse deleteEnvironmentTemplate(DeleteEnvironmentTemplateRequest deleteEnvironmentTemplateRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEnvironmentTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteEnvironmentTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEnvironmentTemplate");
            DeleteEnvironmentTemplateResponse deleteEnvironmentTemplateResponse = (DeleteEnvironmentTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEnvironmentTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEnvironmentTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEnvironmentTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEnvironmentTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteEnvironmentTemplate$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEnvironmentTemplateVersionResponse deleteEnvironmentTemplateVersion(DeleteEnvironmentTemplateVersionRequest deleteEnvironmentTemplateVersionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEnvironmentTemplateVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteEnvironmentTemplateVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEnvironmentTemplateVersion");
            DeleteEnvironmentTemplateVersionResponse deleteEnvironmentTemplateVersionResponse = (DeleteEnvironmentTemplateVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEnvironmentTemplateVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEnvironmentTemplateVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEnvironmentTemplateVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEnvironmentTemplateVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteEnvironmentTemplateVersion$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRepository");
            DeleteRepositoryResponse deleteRepositoryResponse = (DeleteRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRepositoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRepositoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteRepository$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceResponse deleteService(DeleteServiceRequest deleteServiceRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteService");
            DeleteServiceResponse deleteServiceResponse = (DeleteServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteService$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceTemplateResponse deleteServiceTemplate(DeleteServiceTemplateRequest deleteServiceTemplateRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteServiceTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceTemplate");
            DeleteServiceTemplateResponse deleteServiceTemplateResponse = (DeleteServiceTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServiceTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteServiceTemplate$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceTemplateVersionResponse deleteServiceTemplateVersion(DeleteServiceTemplateVersionRequest deleteServiceTemplateVersionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceTemplateVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteServiceTemplateVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceTemplateVersion");
            DeleteServiceTemplateVersionResponse deleteServiceTemplateVersionResponse = (DeleteServiceTemplateVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceTemplateVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServiceTemplateVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceTemplateVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceTemplateVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteServiceTemplateVersion$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTemplateSyncConfigResponse deleteTemplateSyncConfig(DeleteTemplateSyncConfigRequest deleteTemplateSyncConfigRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTemplateSyncConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, deleteTemplateSyncConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTemplateSyncConfig");
            DeleteTemplateSyncConfigResponse deleteTemplateSyncConfigResponse = (DeleteTemplateSyncConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTemplateSyncConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTemplateSyncConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTemplateSyncConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTemplateSyncConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$deleteTemplateSyncConfig$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountSettings");
            GetAccountSettingsResponse getAccountSettingsResponse = (GetAccountSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccountSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getAccountSettings$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComponentResponse getComponent(GetComponentRequest getComponentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetComponentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getComponentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetComponent");
            GetComponentResponse getComponentResponse = (GetComponentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetComponent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComponentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetComponentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getComponentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getComponent$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEnvironmentResponse getEnvironment(GetEnvironmentRequest getEnvironmentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEnvironment");
            GetEnvironmentResponse getEnvironmentResponse = (GetEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getEnvironment$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEnvironmentAccountConnectionResponse getEnvironmentAccountConnection(GetEnvironmentAccountConnectionRequest getEnvironmentAccountConnectionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEnvironmentAccountConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getEnvironmentAccountConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEnvironmentAccountConnection");
            GetEnvironmentAccountConnectionResponse getEnvironmentAccountConnectionResponse = (GetEnvironmentAccountConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEnvironmentAccountConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEnvironmentAccountConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEnvironmentAccountConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEnvironmentAccountConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getEnvironmentAccountConnection$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEnvironmentTemplateResponse getEnvironmentTemplate(GetEnvironmentTemplateRequest getEnvironmentTemplateRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEnvironmentTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getEnvironmentTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEnvironmentTemplate");
            GetEnvironmentTemplateResponse getEnvironmentTemplateResponse = (GetEnvironmentTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEnvironmentTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEnvironmentTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEnvironmentTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEnvironmentTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getEnvironmentTemplate$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEnvironmentTemplateVersionResponse getEnvironmentTemplateVersion(GetEnvironmentTemplateVersionRequest getEnvironmentTemplateVersionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEnvironmentTemplateVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getEnvironmentTemplateVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEnvironmentTemplateVersion");
            GetEnvironmentTemplateVersionResponse getEnvironmentTemplateVersionResponse = (GetEnvironmentTemplateVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEnvironmentTemplateVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEnvironmentTemplateVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEnvironmentTemplateVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEnvironmentTemplateVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getEnvironmentTemplateVersion$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositoryResponse getRepository(GetRepositoryRequest getRepositoryRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepository");
            GetRepositoryResponse getRepositoryResponse = (GetRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRepositoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRepositoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getRepository$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositorySyncStatusResponse getRepositorySyncStatus(GetRepositorySyncStatusRequest getRepositorySyncStatusRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositorySyncStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getRepositorySyncStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositorySyncStatus");
            GetRepositorySyncStatusResponse getRepositorySyncStatusResponse = (GetRepositorySyncStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositorySyncStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRepositorySyncStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRepositorySyncStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRepositorySyncStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getRepositorySyncStatus$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceResponse getService(GetServiceRequest getServiceRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetService");
            GetServiceResponse getServiceResponse = (GetServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getService$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceInstanceResponse getServiceInstance(GetServiceInstanceRequest getServiceInstanceRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getServiceInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceInstance");
            GetServiceInstanceResponse getServiceInstanceResponse = (GetServiceInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServiceInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getServiceInstance$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceTemplateResponse getServiceTemplate(GetServiceTemplateRequest getServiceTemplateRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getServiceTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceTemplate");
            GetServiceTemplateResponse getServiceTemplateResponse = (GetServiceTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServiceTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getServiceTemplate$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceTemplateVersionResponse getServiceTemplateVersion(GetServiceTemplateVersionRequest getServiceTemplateVersionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceTemplateVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getServiceTemplateVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceTemplateVersion");
            GetServiceTemplateVersionResponse getServiceTemplateVersionResponse = (GetServiceTemplateVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceTemplateVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServiceTemplateVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceTemplateVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceTemplateVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getServiceTemplateVersion$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemplateSyncConfigResponse getTemplateSyncConfig(GetTemplateSyncConfigRequest getTemplateSyncConfigRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemplateSyncConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getTemplateSyncConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTemplateSyncConfig");
            GetTemplateSyncConfigResponse getTemplateSyncConfigResponse = (GetTemplateSyncConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemplateSyncConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTemplateSyncConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTemplateSyncConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTemplateSyncConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getTemplateSyncConfig$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemplateSyncStatusResponse getTemplateSyncStatus(GetTemplateSyncStatusRequest getTemplateSyncStatusRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemplateSyncStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, getTemplateSyncStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTemplateSyncStatus");
            GetTemplateSyncStatusResponse getTemplateSyncStatusResponse = (GetTemplateSyncStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemplateSyncStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTemplateSyncStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTemplateSyncStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTemplateSyncStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$getTemplateSyncStatus$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListComponentOutputsResponse listComponentOutputs(ListComponentOutputsRequest listComponentOutputsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListComponentOutputsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listComponentOutputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListComponentOutputs");
            ListComponentOutputsResponse listComponentOutputsResponse = (ListComponentOutputsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListComponentOutputs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listComponentOutputsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListComponentOutputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listComponentOutputsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listComponentOutputs$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListComponentOutputsIterable listComponentOutputsPaginator(ListComponentOutputsRequest listComponentOutputsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListComponentOutputsIterable(this, this.applyPaginatorUserAgent(listComponentOutputsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListComponentProvisionedResourcesResponse listComponentProvisionedResources(ListComponentProvisionedResourcesRequest listComponentProvisionedResourcesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListComponentProvisionedResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listComponentProvisionedResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListComponentProvisionedResources");
            ListComponentProvisionedResourcesResponse listComponentProvisionedResourcesResponse = (ListComponentProvisionedResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListComponentProvisionedResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listComponentProvisionedResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListComponentProvisionedResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listComponentProvisionedResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listComponentProvisionedResources$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListComponentProvisionedResourcesIterable listComponentProvisionedResourcesPaginator(ListComponentProvisionedResourcesRequest listComponentProvisionedResourcesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListComponentProvisionedResourcesIterable(this, this.applyPaginatorUserAgent(listComponentProvisionedResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListComponentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listComponentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListComponents");
            ListComponentsResponse listComponentsResponse = (ListComponentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListComponents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listComponentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListComponentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listComponentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listComponents$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListComponentsIterable listComponentsPaginator(ListComponentsRequest listComponentsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListComponentsIterable(this, this.applyPaginatorUserAgent(listComponentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEnvironmentAccountConnectionsResponse listEnvironmentAccountConnections(ListEnvironmentAccountConnectionsRequest listEnvironmentAccountConnectionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEnvironmentAccountConnectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listEnvironmentAccountConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEnvironmentAccountConnections");
            ListEnvironmentAccountConnectionsResponse listEnvironmentAccountConnectionsResponse = (ListEnvironmentAccountConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEnvironmentAccountConnections").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEnvironmentAccountConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEnvironmentAccountConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEnvironmentAccountConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listEnvironmentAccountConnections$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEnvironmentAccountConnectionsIterable listEnvironmentAccountConnectionsPaginator(ListEnvironmentAccountConnectionsRequest listEnvironmentAccountConnectionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListEnvironmentAccountConnectionsIterable(this, this.applyPaginatorUserAgent(listEnvironmentAccountConnectionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEnvironmentOutputsResponse listEnvironmentOutputs(ListEnvironmentOutputsRequest listEnvironmentOutputsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEnvironmentOutputsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listEnvironmentOutputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEnvironmentOutputs");
            ListEnvironmentOutputsResponse listEnvironmentOutputsResponse = (ListEnvironmentOutputsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEnvironmentOutputs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEnvironmentOutputsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEnvironmentOutputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEnvironmentOutputsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listEnvironmentOutputs$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEnvironmentOutputsIterable listEnvironmentOutputsPaginator(ListEnvironmentOutputsRequest listEnvironmentOutputsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListEnvironmentOutputsIterable(this, this.applyPaginatorUserAgent(listEnvironmentOutputsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEnvironmentProvisionedResourcesResponse listEnvironmentProvisionedResources(ListEnvironmentProvisionedResourcesRequest listEnvironmentProvisionedResourcesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEnvironmentProvisionedResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listEnvironmentProvisionedResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEnvironmentProvisionedResources");
            ListEnvironmentProvisionedResourcesResponse listEnvironmentProvisionedResourcesResponse = (ListEnvironmentProvisionedResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEnvironmentProvisionedResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEnvironmentProvisionedResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEnvironmentProvisionedResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEnvironmentProvisionedResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listEnvironmentProvisionedResources$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEnvironmentProvisionedResourcesIterable listEnvironmentProvisionedResourcesPaginator(ListEnvironmentProvisionedResourcesRequest listEnvironmentProvisionedResourcesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListEnvironmentProvisionedResourcesIterable(this, this.applyPaginatorUserAgent(listEnvironmentProvisionedResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEnvironmentTemplateVersionsResponse listEnvironmentTemplateVersions(ListEnvironmentTemplateVersionsRequest listEnvironmentTemplateVersionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEnvironmentTemplateVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listEnvironmentTemplateVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEnvironmentTemplateVersions");
            ListEnvironmentTemplateVersionsResponse listEnvironmentTemplateVersionsResponse = (ListEnvironmentTemplateVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEnvironmentTemplateVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEnvironmentTemplateVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEnvironmentTemplateVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEnvironmentTemplateVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listEnvironmentTemplateVersions$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEnvironmentTemplateVersionsIterable listEnvironmentTemplateVersionsPaginator(ListEnvironmentTemplateVersionsRequest listEnvironmentTemplateVersionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListEnvironmentTemplateVersionsIterable(this, this.applyPaginatorUserAgent(listEnvironmentTemplateVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEnvironmentTemplatesResponse listEnvironmentTemplates(ListEnvironmentTemplatesRequest listEnvironmentTemplatesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEnvironmentTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listEnvironmentTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEnvironmentTemplates");
            ListEnvironmentTemplatesResponse listEnvironmentTemplatesResponse = (ListEnvironmentTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEnvironmentTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEnvironmentTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEnvironmentTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEnvironmentTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listEnvironmentTemplates$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEnvironmentTemplatesIterable listEnvironmentTemplatesPaginator(ListEnvironmentTemplatesRequest listEnvironmentTemplatesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListEnvironmentTemplatesIterable(this, this.applyPaginatorUserAgent(listEnvironmentTemplatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEnvironmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listEnvironmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEnvironments");
            ListEnvironmentsResponse listEnvironmentsResponse = (ListEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEnvironments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEnvironmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEnvironmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEnvironmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listEnvironments$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEnvironmentsIterable listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListEnvironmentsIterable(this, this.applyPaginatorUserAgent(listEnvironmentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRepositoriesResponse listRepositories(ListRepositoriesRequest listRepositoriesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRepositories");
            ListRepositoriesResponse listRepositoriesResponse = (ListRepositoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRepositoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRepositoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listRepositories$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRepositoriesIterable listRepositoriesPaginator(ListRepositoriesRequest listRepositoriesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListRepositoriesIterable(this, this.applyPaginatorUserAgent(listRepositoriesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRepositorySyncDefinitionsResponse listRepositorySyncDefinitions(ListRepositorySyncDefinitionsRequest listRepositorySyncDefinitionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositorySyncDefinitionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listRepositorySyncDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRepositorySyncDefinitions");
            ListRepositorySyncDefinitionsResponse listRepositorySyncDefinitionsResponse = (ListRepositorySyncDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositorySyncDefinitions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRepositorySyncDefinitionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRepositorySyncDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRepositorySyncDefinitionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listRepositorySyncDefinitions$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRepositorySyncDefinitionsIterable listRepositorySyncDefinitionsPaginator(ListRepositorySyncDefinitionsRequest listRepositorySyncDefinitionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListRepositorySyncDefinitionsIterable(this, this.applyPaginatorUserAgent(listRepositorySyncDefinitionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceInstanceOutputsResponse listServiceInstanceOutputs(ListServiceInstanceOutputsRequest listServiceInstanceOutputsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceInstanceOutputsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listServiceInstanceOutputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceInstanceOutputs");
            ListServiceInstanceOutputsResponse listServiceInstanceOutputsResponse = (ListServiceInstanceOutputsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceInstanceOutputs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServiceInstanceOutputsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceInstanceOutputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceInstanceOutputsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listServiceInstanceOutputs$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServiceInstanceOutputsIterable listServiceInstanceOutputsPaginator(ListServiceInstanceOutputsRequest listServiceInstanceOutputsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListServiceInstanceOutputsIterable(this, this.applyPaginatorUserAgent(listServiceInstanceOutputsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceInstanceProvisionedResourcesResponse listServiceInstanceProvisionedResources(ListServiceInstanceProvisionedResourcesRequest listServiceInstanceProvisionedResourcesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceInstanceProvisionedResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listServiceInstanceProvisionedResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceInstanceProvisionedResources");
            ListServiceInstanceProvisionedResourcesResponse listServiceInstanceProvisionedResourcesResponse = (ListServiceInstanceProvisionedResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceInstanceProvisionedResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServiceInstanceProvisionedResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceInstanceProvisionedResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceInstanceProvisionedResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listServiceInstanceProvisionedResources$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServiceInstanceProvisionedResourcesIterable listServiceInstanceProvisionedResourcesPaginator(ListServiceInstanceProvisionedResourcesRequest listServiceInstanceProvisionedResourcesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListServiceInstanceProvisionedResourcesIterable(this, this.applyPaginatorUserAgent(listServiceInstanceProvisionedResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceInstancesResponse listServiceInstances(ListServiceInstancesRequest listServiceInstancesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listServiceInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceInstances");
            ListServiceInstancesResponse listServiceInstancesResponse = (ListServiceInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServiceInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listServiceInstances$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServiceInstancesIterable listServiceInstancesPaginator(ListServiceInstancesRequest listServiceInstancesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListServiceInstancesIterable(this, this.applyPaginatorUserAgent(listServiceInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicePipelineOutputsResponse listServicePipelineOutputs(ListServicePipelineOutputsRequest listServicePipelineOutputsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicePipelineOutputsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listServicePipelineOutputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServicePipelineOutputs");
            ListServicePipelineOutputsResponse listServicePipelineOutputsResponse = (ListServicePipelineOutputsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServicePipelineOutputs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServicePipelineOutputsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicePipelineOutputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicePipelineOutputsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listServicePipelineOutputs$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServicePipelineOutputsIterable listServicePipelineOutputsPaginator(ListServicePipelineOutputsRequest listServicePipelineOutputsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListServicePipelineOutputsIterable(this, this.applyPaginatorUserAgent(listServicePipelineOutputsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicePipelineProvisionedResourcesResponse listServicePipelineProvisionedResources(ListServicePipelineProvisionedResourcesRequest listServicePipelineProvisionedResourcesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicePipelineProvisionedResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listServicePipelineProvisionedResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServicePipelineProvisionedResources");
            ListServicePipelineProvisionedResourcesResponse listServicePipelineProvisionedResourcesResponse = (ListServicePipelineProvisionedResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServicePipelineProvisionedResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServicePipelineProvisionedResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicePipelineProvisionedResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicePipelineProvisionedResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listServicePipelineProvisionedResources$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServicePipelineProvisionedResourcesIterable listServicePipelineProvisionedResourcesPaginator(ListServicePipelineProvisionedResourcesRequest listServicePipelineProvisionedResourcesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListServicePipelineProvisionedResourcesIterable(this, this.applyPaginatorUserAgent(listServicePipelineProvisionedResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceTemplateVersionsResponse listServiceTemplateVersions(ListServiceTemplateVersionsRequest listServiceTemplateVersionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceTemplateVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listServiceTemplateVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceTemplateVersions");
            ListServiceTemplateVersionsResponse listServiceTemplateVersionsResponse = (ListServiceTemplateVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceTemplateVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServiceTemplateVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceTemplateVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceTemplateVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listServiceTemplateVersions$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServiceTemplateVersionsIterable listServiceTemplateVersionsPaginator(ListServiceTemplateVersionsRequest listServiceTemplateVersionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListServiceTemplateVersionsIterable(this, this.applyPaginatorUserAgent(listServiceTemplateVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceTemplatesResponse listServiceTemplates(ListServiceTemplatesRequest listServiceTemplatesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listServiceTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceTemplates");
            ListServiceTemplatesResponse listServiceTemplatesResponse = (ListServiceTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServiceTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listServiceTemplates$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServiceTemplatesIterable listServiceTemplatesPaginator(ListServiceTemplatesRequest listServiceTemplatesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListServiceTemplatesIterable(this, this.applyPaginatorUserAgent(listServiceTemplatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            ListServicesResponse listServicesResponse = (ListServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listServices$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServicesIterable listServicesPaginator(ListServicesRequest listServicesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListServicesIterable(this, this.applyPaginatorUserAgent(listServicesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$listTagsForResource$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyResourceDeploymentStatusChangeResponse notifyResourceDeploymentStatusChange(NotifyResourceDeploymentStatusChangeRequest notifyResourceDeploymentStatusChangeRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyResourceDeploymentStatusChangeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, notifyResourceDeploymentStatusChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyResourceDeploymentStatusChange");
            NotifyResourceDeploymentStatusChangeResponse notifyResourceDeploymentStatusChangeResponse = (NotifyResourceDeploymentStatusChangeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyResourceDeploymentStatusChange").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)notifyResourceDeploymentStatusChangeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new NotifyResourceDeploymentStatusChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return notifyResourceDeploymentStatusChangeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$notifyResourceDeploymentStatusChange$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectEnvironmentAccountConnectionResponse rejectEnvironmentAccountConnection(RejectEnvironmentAccountConnectionRequest rejectEnvironmentAccountConnectionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectEnvironmentAccountConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, rejectEnvironmentAccountConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectEnvironmentAccountConnection");
            RejectEnvironmentAccountConnectionResponse rejectEnvironmentAccountConnectionResponse = (RejectEnvironmentAccountConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectEnvironmentAccountConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rejectEnvironmentAccountConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectEnvironmentAccountConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectEnvironmentAccountConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$rejectEnvironmentAccountConnection$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$tagResource$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$untagResource$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAccountSettingsResponse updateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccountSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccountSettings");
            UpdateAccountSettingsResponse updateAccountSettingsResponse = (UpdateAccountSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccountSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAccountSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAccountSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateAccountSettings$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateComponentResponse updateComponent(UpdateComponentRequest updateComponentRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateComponentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateComponentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateComponent");
            UpdateComponentResponse updateComponentResponse = (UpdateComponentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateComponent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateComponentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateComponentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateComponentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateComponent$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEnvironment");
            UpdateEnvironmentResponse updateEnvironmentResponse = (UpdateEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateEnvironment$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEnvironmentAccountConnectionResponse updateEnvironmentAccountConnection(UpdateEnvironmentAccountConnectionRequest updateEnvironmentAccountConnectionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEnvironmentAccountConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateEnvironmentAccountConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEnvironmentAccountConnection");
            UpdateEnvironmentAccountConnectionResponse updateEnvironmentAccountConnectionResponse = (UpdateEnvironmentAccountConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEnvironmentAccountConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnvironmentAccountConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEnvironmentAccountConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEnvironmentAccountConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateEnvironmentAccountConnection$66((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEnvironmentTemplateResponse updateEnvironmentTemplate(UpdateEnvironmentTemplateRequest updateEnvironmentTemplateRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEnvironmentTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateEnvironmentTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEnvironmentTemplate");
            UpdateEnvironmentTemplateResponse updateEnvironmentTemplateResponse = (UpdateEnvironmentTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEnvironmentTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnvironmentTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEnvironmentTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEnvironmentTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateEnvironmentTemplate$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEnvironmentTemplateVersionResponse updateEnvironmentTemplateVersion(UpdateEnvironmentTemplateVersionRequest updateEnvironmentTemplateVersionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEnvironmentTemplateVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateEnvironmentTemplateVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEnvironmentTemplateVersion");
            UpdateEnvironmentTemplateVersionResponse updateEnvironmentTemplateVersionResponse = (UpdateEnvironmentTemplateVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEnvironmentTemplateVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnvironmentTemplateVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEnvironmentTemplateVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEnvironmentTemplateVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateEnvironmentTemplateVersion$68((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceResponse updateService(UpdateServiceRequest updateServiceRequest) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateService");
            UpdateServiceResponse updateServiceResponse = (UpdateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateService$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceInstanceResponse updateServiceInstance(UpdateServiceInstanceRequest updateServiceInstanceRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateServiceInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceInstance");
            UpdateServiceInstanceResponse updateServiceInstanceResponse = (UpdateServiceInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateServiceInstance$70((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServicePipelineResponse updateServicePipeline(UpdateServicePipelineRequest updateServicePipelineRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServicePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateServicePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServicePipeline");
            UpdateServicePipelineResponse updateServicePipelineResponse = (UpdateServicePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServicePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServicePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServicePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServicePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateServicePipeline$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceTemplateResponse updateServiceTemplate(UpdateServiceTemplateRequest updateServiceTemplateRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateServiceTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceTemplate");
            UpdateServiceTemplateResponse updateServiceTemplateResponse = (UpdateServiceTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateServiceTemplate$72((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceTemplateVersionResponse updateServiceTemplateVersion(UpdateServiceTemplateVersionRequest updateServiceTemplateVersionRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceTemplateVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateServiceTemplateVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceTemplateVersion");
            UpdateServiceTemplateVersionResponse updateServiceTemplateVersionResponse = (UpdateServiceTemplateVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceTemplateVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceTemplateVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceTemplateVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceTemplateVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateServiceTemplateVersion$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTemplateSyncConfigResponse updateTemplateSyncConfig(UpdateTemplateSyncConfigRequest updateTemplateSyncConfigRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ProtonException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTemplateSyncConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultProtonClient.resolveMetricPublishers(this.clientConfiguration, updateTemplateSyncConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Proton");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTemplateSyncConfig");
            UpdateTemplateSyncConfigResponse updateTemplateSyncConfigResponse = (UpdateTemplateSyncConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTemplateSyncConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTemplateSyncConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTemplateSyncConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTemplateSyncConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultProtonClient.lambda$updateTemplateSyncConfig$74((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ProtonException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ProtonRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.19.16").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ProtonRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public ProtonWaiter waiter() {
        return ProtonWaiter.builder().client(this).build();
    }

    private static /* synthetic */ void lambda$updateTemplateSyncConfig$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateServiceTemplateVersion$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateServiceTemplate$72(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateServicePipeline$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateServiceInstance$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateService$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEnvironmentTemplateVersion$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEnvironmentTemplate$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEnvironmentAccountConnection$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEnvironment$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateComponent$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccountSettings$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectEnvironmentAccountConnection$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyResourceDeploymentStatusChange$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServices$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceTemplates$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceTemplateVersions$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServicePipelineProvisionedResources$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServicePipelineOutputs$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceInstances$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceInstanceProvisionedResources$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceInstanceOutputs$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRepositorySyncDefinitions$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRepositories$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEnvironments$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEnvironmentTemplates$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEnvironmentTemplateVersions$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEnvironmentProvisionedResources$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEnvironmentOutputs$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEnvironmentAccountConnections$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listComponents$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listComponentProvisionedResources$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listComponentOutputs$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTemplateSyncStatus$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTemplateSyncConfig$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceTemplateVersion$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceTemplate$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceInstance$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getService$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositorySyncStatus$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepository$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEnvironmentTemplateVersion$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEnvironmentTemplate$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEnvironmentAccountConnection$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEnvironment$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getComponent$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccountSettings$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTemplateSyncConfig$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServiceTemplateVersion$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServiceTemplate$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteService$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRepository$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEnvironmentTemplateVersion$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEnvironmentTemplate$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEnvironmentAccountConnection$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEnvironment$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteComponent$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTemplateSyncConfig$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createServiceTemplateVersion$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createServiceTemplate$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createService$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRepository$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEnvironmentTemplateVersion$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEnvironmentTemplate$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEnvironmentAccountConnection$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEnvironment$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createComponent$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelServicePipelineDeployment$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelServiceInstanceDeployment$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelEnvironmentDeployment$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelComponentDeployment$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptEnvironmentAccountConnection$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

