/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.EnvironmentSummary;
import software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentsResponse;

public class ListEnvironmentsIterable
implements SdkIterable<ListEnvironmentsResponse> {
    private final ProtonClient client;
    private final ListEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentsIterable(ProtonClient client, ListEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEnvironmentsResponseFetcher();
    }

    public Iterator<ListEnvironmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentSummary> environments() {
        Function<ListEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environments() != null) {
                return response.environments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentsResponse> {
        private ListEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentsResponse nextPage(ListEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentsIterable.this.client.listEnvironments(ListEnvironmentsIterable.this.firstRequest);
            }
            return ListEnvironmentsIterable.this.client.listEnvironments((ListEnvironmentsRequest)((Object)ListEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

