/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse;
import software.amazon.awssdk.services.proton.model.ServiceTemplateSummary;

public class ListServiceTemplatesPublisher
implements SdkPublisher<ListServiceTemplatesResponse> {
    private final ProtonAsyncClient client;
    private final ListServiceTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceTemplatesPublisher(ProtonAsyncClient client, ListServiceTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceTemplatesPublisher(ProtonAsyncClient client, ListServiceTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceTemplateSummary> templates() {
        Function<ListServiceTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templates() != null) {
                return response.templates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceTemplatesResponseFetcher
    implements AsyncPageFetcher<ListServiceTemplatesResponse> {
        private ListServiceTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceTemplatesResponse> nextPage(ListServiceTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceTemplatesPublisher.this.client.listServiceTemplates(ListServiceTemplatesPublisher.this.firstRequest);
            }
            return ListServiceTemplatesPublisher.this.client.listServiceTemplates((ListServiceTemplatesRequest)((Object)ListServiceTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

