/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse;
import software.amazon.awssdk.services.proton.model.ServiceTemplateSummary;

public class ListServiceTemplatesIterable
implements SdkIterable<ListServiceTemplatesResponse> {
    private final ProtonClient client;
    private final ListServiceTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceTemplatesIterable(ProtonClient client, ListServiceTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServiceTemplatesResponseFetcher();
    }

    public Iterator<ListServiceTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceTemplateSummary> templates() {
        Function<ListServiceTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templates() != null) {
                return response.templates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceTemplatesResponseFetcher
    implements SyncPageFetcher<ListServiceTemplatesResponse> {
        private ListServiceTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceTemplatesResponse nextPage(ListServiceTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceTemplatesIterable.this.client.listServiceTemplates(ListServiceTemplatesIterable.this.firstRequest);
            }
            return ListServiceTemplatesIterable.this.client.listServiceTemplates((ListServiceTemplatesRequest)((Object)ListServiceTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

