/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionRequesterAccountType;
import software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionStatus;
import software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionStatusListCopier;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentAccountConnectionsRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, ListEnvironmentAccountConnectionsRequest> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(ListEnvironmentAccountConnectionsRequest.getter(ListEnvironmentAccountConnectionsRequest::environmentName)).setter(ListEnvironmentAccountConnectionsRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListEnvironmentAccountConnectionsRequest.getter(ListEnvironmentAccountConnectionsRequest::maxResults)).setter(ListEnvironmentAccountConnectionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnvironmentAccountConnectionsRequest.getter(ListEnvironmentAccountConnectionsRequest::nextToken)).setter(ListEnvironmentAccountConnectionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestedBy").getter(ListEnvironmentAccountConnectionsRequest.getter(ListEnvironmentAccountConnectionsRequest::requestedByAsString)).setter(ListEnvironmentAccountConnectionsRequest.setter(Builder::requestedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedBy").build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statuses").getter(ListEnvironmentAccountConnectionsRequest.getter(ListEnvironmentAccountConnectionsRequest::statusesAsStrings)).setter(ListEnvironmentAccountConnectionsRequest.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REQUESTED_BY_FIELD, STATUSES_FIELD));
    private final String environmentName;
    private final Integer maxResults;
    private final String nextToken;
    private final String requestedBy;
    private final List<String> statuses;

    private ListEnvironmentAccountConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.requestedBy = builder.requestedBy;
        this.statuses = builder.statuses;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final EnvironmentAccountConnectionRequesterAccountType requestedBy() {
        return EnvironmentAccountConnectionRequesterAccountType.fromValue(this.requestedBy);
    }

    public final String requestedByAsString() {
        return this.requestedBy;
    }

    public final List<EnvironmentAccountConnectionStatus> statuses() {
        return EnvironmentAccountConnectionStatusListCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentAccountConnectionsRequest)) {
            return false;
        }
        ListEnvironmentAccountConnectionsRequest other = (ListEnvironmentAccountConnectionsRequest)((Object)obj);
        return Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestedByAsString(), other.requestedByAsString()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnvironmentAccountConnectionsRequest").add("EnvironmentName", (Object)this.environmentName()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("RequestedBy", (Object)this.requestedByAsString()).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "requestedBy": {
                return Optional.ofNullable(clazz.cast(this.requestedByAsString()));
            }
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentAccountConnectionsRequest, T> g) {
        return obj -> g.apply((ListEnvironmentAccountConnectionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String environmentName;
        private Integer maxResults;
        private String nextToken;
        private String requestedBy;
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentAccountConnectionsRequest model) {
            super(model);
            this.environmentName(model.environmentName);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.requestedBy(model.requestedBy);
            this.statusesWithStrings(model.statuses);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestedBy() {
            return this.requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        @Override
        public final Builder requestedBy(EnvironmentAccountConnectionRequesterAccountType requestedBy) {
            this.requestedBy(requestedBy == null ? null : requestedBy.toString());
            return this;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = EnvironmentAccountConnectionStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<EnvironmentAccountConnectionStatus> statuses) {
            this.statuses = EnvironmentAccountConnectionStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(EnvironmentAccountConnectionStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = EnvironmentAccountConnectionStatusListCopier.copy(statuses);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnvironmentAccountConnectionsRequest build() {
            return new ListEnvironmentAccountConnectionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentAccountConnectionsRequest> {
        public Builder environmentName(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestedBy(String var1);

        public Builder requestedBy(EnvironmentAccountConnectionRequesterAccountType var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<EnvironmentAccountConnectionStatus> var1);

        public Builder statuses(EnvironmentAccountConnectionStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

