/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocoljsonrpc.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.protocoljsonrpc.model.RecursiveStructType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RecursiveStructType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RecursiveStructTypeMarshaller {
    private static final MarshallingInfo<String> NORECURSE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NoRecurse").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RECURSIVESTRUCT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RecursiveStruct").isBinary(false).build();

    private static final MarshallingInfo<List> RECURSIVELIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecursiveList").isBinary(false).build();

    private static final MarshallingInfo<Map> RECURSIVEMAP_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecursiveMap").isBinary(false).build();

    private static final RecursiveStructTypeMarshaller INSTANCE = new RecursiveStructTypeMarshaller();

    private RecursiveStructTypeMarshaller() {
    }

    public static RecursiveStructTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RecursiveStructType recursiveStructType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(recursiveStructType, "recursiveStructType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(recursiveStructType.noRecurse(), NORECURSE_BINDING);
            protocolMarshaller.marshall(recursiveStructType.recursiveStruct(), RECURSIVESTRUCT_BINDING);
            protocolMarshaller.marshall(recursiveStructType.recursiveList(), RECURSIVELIST_BINDING);
            protocolMarshaller.marshall(recursiveStructType.recursiveMap(), RECURSIVEMAP_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
