/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationWithModeledContentTypeRequest extends ProtocolRestXmlRequest implements
        ToCopyableBuilder<OperationWithModeledContentTypeRequest.Builder, OperationWithModeledContentTypeRequest> {
    private final String contentType;

    private OperationWithModeledContentTypeRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
    }

    /**
     * Returns the value of the ContentType property for this object.
     * 
     * @return The value of the ContentType property for this object.
     */
    public String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationWithModeledContentTypeRequest)) {
            return false;
        }
        OperationWithModeledContentTypeRequest other = (OperationWithModeledContentTypeRequest) obj;
        return Objects.equals(contentType(), other.contentType());
    }

    @Override
    public String toString() {
        return ToString.builder("OperationWithModeledContentTypeRequest").add("ContentType", contentType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.of(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolRestXmlRequest.Builder,
            CopyableBuilder<Builder, OperationWithModeledContentTypeRequest> {
        /**
         * Sets the value of the ContentType property for this object.
         *
         * @param contentType
         *        The new value for the ContentType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ProtocolRestXmlRequest.BuilderImpl implements Builder {
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationWithModeledContentTypeRequest model) {
            contentType(model.contentType);
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public OperationWithModeledContentTypeRequest build() {
            return new OperationWithModeledContentTypeRequest(this);
        }
    }
}
