/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationWithExplicitPayloadBlobResponse extends ProtocolRestXmlResponse implements
        ToCopyableBuilder<OperationWithExplicitPayloadBlobResponse.Builder, OperationWithExplicitPayloadBlobResponse> {
    private final ByteBuffer payloadMember;

    private OperationWithExplicitPayloadBlobResponse(BuilderImpl builder) {
        super(builder);
        this.payloadMember = builder.payloadMember;
    }

    /**
     * Returns the value of the PayloadMember property for this object.
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The value of the PayloadMember property for this object.
     */
    public ByteBuffer payloadMember() {
        return payloadMember == null ? null : payloadMember.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payloadMember());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationWithExplicitPayloadBlobResponse)) {
            return false;
        }
        OperationWithExplicitPayloadBlobResponse other = (OperationWithExplicitPayloadBlobResponse) obj;
        return Objects.equals(payloadMember(), other.payloadMember());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (payloadMember() != null) {
            sb.append("PayloadMember: ").append(payloadMember()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PayloadMember":
            return Optional.of(clazz.cast(payloadMember()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolRestXmlResponse.Builder,
            CopyableBuilder<Builder, OperationWithExplicitPayloadBlobResponse> {
        /**
         * Sets the value of the PayloadMember property for this object.
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param payloadMember
         *        The new value for the PayloadMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMember(ByteBuffer payloadMember);
    }

    static final class BuilderImpl extends ProtocolRestXmlResponse.BuilderImpl implements Builder {
        private ByteBuffer payloadMember;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationWithExplicitPayloadBlobResponse model) {
            payloadMember(model.payloadMember);
        }

        public final ByteBuffer getPayloadMember() {
            return payloadMember;
        }

        @Override
        public final Builder payloadMember(ByteBuffer payloadMember) {
            this.payloadMember = StandardMemberCopier.copy(payloadMember);
            return this;
        }

        public final void setPayloadMember(ByteBuffer payloadMember) {
            this.payloadMember = StandardMemberCopier.copy(payloadMember);
        }

        @Override
        public OperationWithExplicitPayloadBlobResponse build() {
            return new OperationWithExplicitPayloadBlobResponse(this);
        }
    }
}
