/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolrestxml.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.IdempotentUtils;

/**
 * IdempotentOperationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class IdempotentOperationRequestMarshaller implements
        Marshaller<Request<IdempotentOperationRequest>, IdempotentOperationRequest> {

    public Request<IdempotentOperationRequest> marshall(IdempotentOperationRequest idempotentOperationRequest) {

        if (idempotentOperationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<IdempotentOperationRequest> request = new DefaultRequest<IdempotentOperationRequest>(idempotentOperationRequest,
                "ProtocolRestXmlClient");

        request.setHttpMethod(HttpMethodName.POST);

        request.addHeader("x-amz-idempotent-header",
                IdempotentUtils.resolveString(idempotentOperationRequest.headerIdempotentToken()));

        String uriResourcePath = "/2016-03-11/idempotentOperation/{PathParam}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.IDEMPOTENCY.marshall(uriResourcePath,
                "PathParam", idempotentOperationRequest.pathIdempotentToken());
        request.setResourcePath(uriResourcePath);

        request.addParameter("QueryParam", IdempotentUtils.resolveString(idempotentOperationRequest.queryIdempotentToken()));

        return request;
    }

}