/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PayloadStructType implements ToCopyableBuilder<PayloadStructType.Builder, PayloadStructType> {
    private final String payloadMemberOne;

    private final String payloadMemberTwo;

    private PayloadStructType(BuilderImpl builder) {
        this.payloadMemberOne = builder.payloadMemberOne;
        this.payloadMemberTwo = builder.payloadMemberTwo;
    }

    /**
     * Returns the value of the PayloadMemberOne property for this object.
     * 
     * @return The value of the PayloadMemberOne property for this object.
     */
    public String payloadMemberOne() {
        return payloadMemberOne;
    }

    /**
     * Returns the value of the PayloadMemberTwo property for this object.
     * 
     * @return The value of the PayloadMemberTwo property for this object.
     */
    public String payloadMemberTwo() {
        return payloadMemberTwo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((payloadMemberOne() == null) ? 0 : payloadMemberOne().hashCode());
        hashCode = 31 * hashCode + ((payloadMemberTwo() == null) ? 0 : payloadMemberTwo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayloadStructType)) {
            return false;
        }
        PayloadStructType other = (PayloadStructType) obj;
        if (other.payloadMemberOne() == null ^ this.payloadMemberOne() == null) {
            return false;
        }
        if (other.payloadMemberOne() != null && !other.payloadMemberOne().equals(this.payloadMemberOne())) {
            return false;
        }
        if (other.payloadMemberTwo() == null ^ this.payloadMemberTwo() == null) {
            return false;
        }
        if (other.payloadMemberTwo() != null && !other.payloadMemberTwo().equals(this.payloadMemberTwo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (payloadMemberOne() != null) {
            sb.append("PayloadMemberOne: ").append(payloadMemberOne()).append(",");
        }
        if (payloadMemberTwo() != null) {
            sb.append("PayloadMemberTwo: ").append(payloadMemberTwo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PayloadMemberOne":
            return Optional.of(clazz.cast(payloadMemberOne()));
        case "PayloadMemberTwo":
            return Optional.of(clazz.cast(payloadMemberTwo()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PayloadStructType> {
        /**
         * Sets the value of the PayloadMemberOne property for this object.
         *
         * @param payloadMemberOne
         *        The new value for the PayloadMemberOne property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMemberOne(String payloadMemberOne);

        /**
         * Sets the value of the PayloadMemberTwo property for this object.
         *
         * @param payloadMemberTwo
         *        The new value for the PayloadMemberTwo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMemberTwo(String payloadMemberTwo);
    }

    static final class BuilderImpl implements Builder {
        private String payloadMemberOne;

        private String payloadMemberTwo;

        private BuilderImpl() {
        }

        private BuilderImpl(PayloadStructType model) {
            payloadMemberOne(model.payloadMemberOne);
            payloadMemberTwo(model.payloadMemberTwo);
        }

        public final String getPayloadMemberOne() {
            return payloadMemberOne;
        }

        @Override
        public final Builder payloadMemberOne(String payloadMemberOne) {
            this.payloadMemberOne = payloadMemberOne;
            return this;
        }

        public final void setPayloadMemberOne(String payloadMemberOne) {
            this.payloadMemberOne = payloadMemberOne;
        }

        public final String getPayloadMemberTwo() {
            return payloadMemberTwo;
        }

        @Override
        public final Builder payloadMemberTwo(String payloadMemberTwo) {
            this.payloadMemberTwo = payloadMemberTwo;
            return this;
        }

        public final void setPayloadMemberTwo(String payloadMemberTwo) {
            this.payloadMemberTwo = payloadMemberTwo;
        }

        @Override
        public PayloadStructType build() {
            return new PayloadStructType(this);
        }
    }
}
