/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.protocolrestjson.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * OperationWithGreedyLabelRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class OperationWithGreedyLabelRequestModelMarshaller {

    private static final MarshallingInfo<String> NONGREEDYPATHPARAM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("NonGreedyPathParam").build();
    private static final MarshallingInfo<String> GREEDYPATHPARAM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.GREEDY_PATH).marshallLocationName("GreedyPathParam").build();

    private static final OperationWithGreedyLabelRequestModelMarshaller INSTANCE = new OperationWithGreedyLabelRequestModelMarshaller();

    public static OperationWithGreedyLabelRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(OperationWithGreedyLabelRequest operationWithGreedyLabelRequest, ProtocolMarshaller protocolMarshaller) {

        if (operationWithGreedyLabelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(operationWithGreedyLabelRequest.nonGreedyPathParam(), NONGREEDYPATHPARAM_BINDING);

            protocolMarshaller.marshall(operationWithGreedyLabelRequest.greedyPathParam(), GREEDYPATHPARAM_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
