/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationWithModeledContentTypeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<OperationWithModeledContentTypeRequest.Builder, OperationWithModeledContentTypeRequest> {
    private final String contentType;

    private OperationWithModeledContentTypeRequest(BuilderImpl builder) {
        this.contentType = builder.contentType;
    }

    /**
     * Returns the value of the ContentType property for this object.
     * 
     * @return The value of the ContentType property for this object.
     */
    public String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((contentType() == null) ? 0 : contentType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationWithModeledContentTypeRequest)) {
            return false;
        }
        OperationWithModeledContentTypeRequest other = (OperationWithModeledContentTypeRequest) obj;
        if (other.contentType() == null ^ this.contentType() == null) {
            return false;
        }
        if (other.contentType() != null && !other.contentType().equals(this.contentType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (contentType() != null) {
            sb.append("ContentType: ").append(contentType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.of(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, OperationWithModeledContentTypeRequest> {
        /**
         * Sets the value of the ContentType property for this object.
         *
         * @param contentType
         *        The new value for the ContentType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationWithModeledContentTypeRequest model) {
            contentType(model.contentType);
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public OperationWithModeledContentTypeRequest build() {
            return new OperationWithModeledContentTypeRequest(this);
        }
    }
}
