/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson;

import java.nio.file.Path;
import javax.annotation.Generated;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocolrestjson.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolrestjson.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolrestjson.model.DeleteOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.DeleteOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.EmptyModeledException;
import software.amazon.awssdk.services.protocolrestjson.model.HeadOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.HeadOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.JsonValuesOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.JsonValuesOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MapOfStringToListOfStringInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MapOfStringToListOfStringInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInHeadersRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInHeadersResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MultiLocationOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MultiLocationOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.NestedContainersRequest;
import software.amazon.awssdk.services.protocolrestjson.model.NestedContainersResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadBlobRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadBlobResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadStructureRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadStructureResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithGreedyLabelRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithGreedyLabelResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithModeledContentTypeRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithModeledContentTypeResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.services.protocolrestjson.model.ProtocolRestJsonException;
import software.amazon.awssdk.services.protocolrestjson.model.QueryParamWithoutValueRequest;
import software.amazon.awssdk.services.protocolrestjson.model.QueryParamWithoutValueResponse;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingInputOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingInputOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingOutputOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingOutputOperationResponse;
import software.amazon.awssdk.sync.RequestBody;
import software.amazon.awssdk.sync.ResponseInputStream;
import software.amazon.awssdk.sync.StreamingResponseHandler;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing AmazonProtocolRestJson. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolRestJsonClient extends SdkAutoCloseable {
    String SERVICE_NAME = "restjson";

    /**
     * Create a {@link ProtocolRestJsonClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static ProtocolRestJsonClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolRestJsonClient}.
     */
    static ProtocolRestJsonClientBuilder builder() {
        return new DefaultProtocolRestJsonClientBuilder();
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.AllTypes
     * @see #allTypes(AllTypesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default AllTypesResponse allTypes() throws EmptyModeledException, SdkBaseException, SdkClientException,
            ProtocolRestJsonException {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws EmptyModeledException, SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteOperation operation.
     *
     * @return Result of the DeleteOperation operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.DeleteOperation
     * @see #deleteOperation(DeleteOperationRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOperationResponse deleteOperation() throws SdkBaseException, SdkClientException, ProtocolRestJsonException {
        return deleteOperation(DeleteOperationRequest.builder().build());
    }

    /**
     * Invokes the DeleteOperation operation.
     *
     * @param deleteOperationRequest
     * @return Result of the DeleteOperation operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.DeleteOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOperationResponse deleteOperation(DeleteOperationRequest deleteOperationRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the HeadOperation operation.
     *
     * @return Result of the HeadOperation operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.HeadOperation
     * @see #headOperation(HeadOperationRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default HeadOperationResponse headOperation() throws SdkBaseException, SdkClientException, ProtocolRestJsonException {
        return headOperation(HeadOperationRequest.builder().build());
    }

    /**
     * Invokes the HeadOperation operation.
     *
     * @param headOperationRequest
     * @return Result of the HeadOperation operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.HeadOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default HeadOperationResponse headOperation(HeadOperationRequest headOperationRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws SdkBaseException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the JsonValuesOperation operation.
     *
     * @return Result of the JsonValuesOperation operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.JsonValuesOperation
     * @see #jsonValuesOperation(JsonValuesOperationRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default JsonValuesOperationResponse jsonValuesOperation() throws EmptyModeledException, SdkBaseException, SdkClientException,
            ProtocolRestJsonException {
        return jsonValuesOperation(JsonValuesOperationRequest.builder().build());
    }

    /**
     * Invokes the JsonValuesOperation operation.
     *
     * @param jsonValuesOperationRequest
     * @return Result of the JsonValuesOperation operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.JsonValuesOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default JsonValuesOperationResponse jsonValuesOperation(JsonValuesOperationRequest jsonValuesOperationRequest)
            throws EmptyModeledException, SdkBaseException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     *
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MapOfStringToListOfStringInQueryParams
     * @see #mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams() throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        return mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MapOfStringToListOfStringInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInHeaders operation.
     *
     * @return Result of the MembersInHeaders operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInHeaders
     * @see #membersInHeaders(MembersInHeadersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default MembersInHeadersResponse membersInHeaders() throws SdkBaseException, SdkClientException, ProtocolRestJsonException {
        return membersInHeaders(MembersInHeadersRequest.builder().build());
    }

    /**
     * Invokes the MembersInHeaders operation.
     *
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInHeaders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default MembersInHeadersResponse membersInHeaders(MembersInHeadersRequest membersInHeadersRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInQueryParams operation.
     *
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInQueryParams
     * @see #membersInQueryParams(MembersInQueryParamsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default MembersInQueryParamsResponse membersInQueryParams() throws SdkBaseException, SdkClientException,
            ProtocolRestJsonException {
        return membersInQueryParams(MembersInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the MembersInQueryParams operation.
     *
     * @param membersInQueryParamsRequest
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default MembersInQueryParamsResponse membersInQueryParams(MembersInQueryParamsRequest membersInQueryParamsRequest)
            throws SdkBaseException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiLocationOperation operation.
     *
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MultiLocationOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MultiLocationOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default MultiLocationOperationResponse multiLocationOperation(MultiLocationOperationRequest multiLocationOperationRequest)
            throws SdkBaseException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the NestedContainers operation.
     *
     * @return Result of the NestedContainers operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.NestedContainers
     * @see #nestedContainers(NestedContainersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default NestedContainersResponse nestedContainers() throws SdkBaseException, SdkClientException, ProtocolRestJsonException {
        return nestedContainers(NestedContainersRequest.builder().build());
    }

    /**
     * Invokes the NestedContainers operation.
     *
     * @param nestedContainersRequest
     * @return Result of the NestedContainers operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default NestedContainersResponse nestedContainers(NestedContainersRequest nestedContainersRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     *
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadBlob
     * @see #operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob() throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        return operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest.builder().build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     *
     * @param operationWithExplicitPayloadBlobRequest
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob(
            OperationWithExplicitPayloadBlobRequest operationWithExplicitPayloadBlobRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation.
     *
     * @return Result of the OperationWithExplicitPayloadStructure operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadStructure
     * @see #operationWithExplicitPayloadStructure(OperationWithExplicitPayloadStructureRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadStructureResponse operationWithExplicitPayloadStructure() throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        return operationWithExplicitPayloadStructure(OperationWithExplicitPayloadStructureRequest.builder().build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation.
     *
     * @param operationWithExplicitPayloadStructureRequest
     * @return Result of the OperationWithExplicitPayloadStructure operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadStructure
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadStructureResponse operationWithExplicitPayloadStructure(
            OperationWithExplicitPayloadStructureRequest operationWithExplicitPayloadStructureRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithGreedyLabel operation.
     *
     * @param operationWithGreedyLabelRequest
     * @return Result of the OperationWithGreedyLabel operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithGreedyLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithGreedyLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithGreedyLabelResponse operationWithGreedyLabel(
            OperationWithGreedyLabelRequest operationWithGreedyLabelRequest) throws SdkBaseException, SdkClientException,
            ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     *
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithModeledContentType
     * @see #operationWithModeledContentType(OperationWithModeledContentTypeRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType() throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        return operationWithModeledContentType(OperationWithModeledContentTypeRequest.builder().build());
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     *
     * @param operationWithModeledContentTypeRequest
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithModeledContentType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     *
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithNoInputOrOutput
     * @see #operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput() throws SdkBaseException, SdkClientException,
            ProtocolRestJsonException {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder().build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     *
     * @param operationWithNoInputOrOutputRequest
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) throws SdkBaseException, SdkClientException,
            ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     *
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.QueryParamWithoutValue
     * @see #queryParamWithoutValue(QueryParamWithoutValueRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue() throws SdkBaseException, SdkClientException,
            ProtocolRestJsonException {
        return queryParamWithoutValue(QueryParamWithoutValueRequest.builder().build());
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     *
     * @param queryParamWithoutValueRequest
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.QueryParamWithoutValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue(QueryParamWithoutValueRequest queryParamWithoutValueRequest)
            throws SdkBaseException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StreamingInputOperation operation.
     *
     * @param streamingInputOperationRequest
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.of(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows ''
     * @return Result of the StreamingInputOperation operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingInputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StreamingInputOperationResponse streamingInputOperation(
            StreamingInputOperationRequest streamingInputOperationRequest, RequestBody requestBody) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StreamingInputOperation operation.
     *
     * @param streamingInputOperationRequest
     * @param path
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows ''
     * @return Result of the StreamingInputOperation operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingInputOperation
     * @see #streamingInputOperation(StreamingInputOperationRequest, RequestBody)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StreamingInputOperationResponse streamingInputOperation(
            StreamingInputOperationRequest streamingInputOperationRequest, Path filePath) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        return streamingInputOperation(streamingInputOperationRequest, RequestBody.of(filePath));
    }

    /**
     * Invokes the StreamingOutputOperation operation.
     *
     * @param streamingOutputOperationRequest
     * @param streamingHandler
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        StreamingInputOperationRequest and an InputStream to the response content are provided as parameters to
     *        the callback. The callback may return a transformed type which will be the return value of this method.
     *        See {@link software.amazon.awssdk.runtime.transform.StreamingResponseHandler} for details on implementing
     *        this interface and for links to pre-canned implementations for common scenarios like downloading to a
     *        file. The service documentation for the response content is as follows ''.
     * @return The transformed result of the StreamingResponseHandler.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT streamingOutputOperation(StreamingOutputOperationRequest streamingOutputOperationRequest,
            StreamingResponseHandler<StreamingOutputOperationResponse, ReturnT> streamingResponseHandler)
            throws SdkBaseException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StreamingOutputOperation operation.
     *
     * @param streamingOutputOperationRequest
     * @param path
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows ''.
     * @return The transformed result of the StreamingResponseHandler.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see #streamingOutputOperation(StreamingOutputOperationRequest, StreamingResponseHandler)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StreamingOutputOperationResponse streamingOutputOperation(
            StreamingOutputOperationRequest streamingOutputOperationRequest, Path filePath) throws SdkBaseException,
            SdkClientException, ProtocolRestJsonException {
        return streamingOutputOperation(streamingOutputOperationRequest, StreamingResponseHandler.toFile(filePath));
    }

    /**
     * Invokes the StreamingOutputOperation operation.
     *
     * @param streamingOutputOperationRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         ''.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see #getObject(streamingOutputOperation, StreamingResponseHandler)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<StreamingOutputOperationResponse> streamingOutputOperation(
            StreamingOutputOperationRequest streamingOutputOperationRequest) throws SdkBaseException, SdkClientException,
            ProtocolRestJsonException {
        return streamingOutputOperation(streamingOutputOperationRequest, StreamingResponseHandler.toInputStream());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("restjson");
    }
}
