/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.protocolec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * Ec2TypesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class Ec2TypesResponseUnmarshaller implements Unmarshaller<Ec2TypesResponse, StaxUnmarshallerContext> {

    public Ec2TypesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        Ec2TypesResponse.Builder ec2TypesResponse = Ec2TypesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> flattenedListOfStrings = null;
        java.util.List<SimpleStruct> flattenedListOfStructs = null;
        java.util.List<String> flattenedListWithLocation = null;
        java.util.List<String> listMemberWithLocationAndQueryName = null;
        java.util.List<String> listMemberWithOnlyMemberLocation = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                ec2TypesResponse.flattenedListOfStrings(flattenedListOfStrings);
                ec2TypesResponse.flattenedListOfStructs(flattenedListOfStructs);
                ec2TypesResponse.flattenedListWithLocation(flattenedListWithLocation);
                ec2TypesResponse.listMemberWithLocationAndQueryName(listMemberWithLocationAndQueryName);
                ec2TypesResponse.listMemberWithOnlyMemberLocation(listMemberWithOnlyMemberLocation);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("FlattenedListOfStrings", targetDepth)) {
                    if (flattenedListOfStrings == null) {
                        flattenedListOfStrings = new ArrayList<>();
                    }
                    flattenedListOfStrings.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FlattenedListOfStructs", targetDepth)) {
                    if (flattenedListOfStructs == null) {
                        flattenedListOfStructs = new ArrayList<>();
                    }
                    flattenedListOfStructs.add(SimpleStructUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("item", targetDepth)) {
                    if (flattenedListWithLocation == null) {
                        flattenedListWithLocation = new ArrayList<>();
                    }
                    flattenedListWithLocation.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("someLocation", targetDepth)) {
                    ec2TypesResponse.stringMemberWithLocation(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StringMemberWithQueryName", targetDepth)) {
                    ec2TypesResponse.stringMemberWithQueryName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StringMemberWithLocationAndQueryName", targetDepth)) {
                    ec2TypesResponse.stringMemberWithLocationAndQueryName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("someLocation", targetDepth)) {
                    listMemberWithLocationAndQueryName = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("someLocation/member", targetDepth)) {
                    listMemberWithLocationAndQueryName.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("item", targetDepth)) {
                    listMemberWithOnlyMemberLocation = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("item/member", targetDepth)) {
                    listMemberWithOnlyMemberLocation.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    ec2TypesResponse.flattenedListOfStrings(flattenedListOfStrings);
                    ec2TypesResponse.flattenedListOfStructs(flattenedListOfStructs);
                    ec2TypesResponse.flattenedListWithLocation(flattenedListWithLocation);
                    ec2TypesResponse.listMemberWithLocationAndQueryName(listMemberWithLocationAndQueryName);
                    ec2TypesResponse.listMemberWithOnlyMemberLocation(listMemberWithOnlyMemberLocation);
                    break;
                }
            }
        }
        return ec2TypesResponse.build();
    }

    private static final Ec2TypesResponseUnmarshaller INSTANCE = new Ec2TypesResponseUnmarshaller();

    public static Ec2TypesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
