/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml;

import javax.annotation.Generated;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.EmptyModeledException;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeResponse;
import software.amazon.awssdk.services.protocolrestxml.model.ProtocolRestXmlException;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueRequest;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueResponse;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesResponse;

/**
 * Service client for accessing AmazonProtocolRestXml. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolRestXmlClient extends AutoCloseable {
    String SERVICE_NAME = "restxml";

    /**
     * Create a {@link ProtocolRestXmlClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static ProtocolRestXmlClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolRestXmlClient}.
     */
    static ProtocolRestXmlClientBuilder builder() {
        return new DefaultProtocolRestXmlClientBuilder();
    }

    /**
     * Invokes the AllTypes operation.
     * 
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ProtocolRestXmlException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ProtocolRestXmlClient.AllTypes
     */
    default AllTypesResponse allTypes() throws EmptyModeledException, SdkBaseException, SdkClientException,
            ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation.
     * 
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ProtocolRestXmlException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ProtocolRestXmlClient.AllTypes
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws EmptyModeledException, SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteOperation operation.
     * 
     * @param deleteOperationRequest
     * @return Result of the DeleteOperation operation returned by the service.
     * @sample ProtocolRestXmlClient.DeleteOperation
     */
    default DeleteOperationResponse deleteOperation() throws SdkBaseException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteOperation operation.
     * 
     * @param deleteOperationRequest
     * @return Result of the DeleteOperation operation returned by the service.
     * @sample ProtocolRestXmlClient.DeleteOperation
     */
    default DeleteOperationResponse deleteOperation(DeleteOperationRequest deleteOperationRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation.
     * 
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @sample ProtocolRestXmlClient.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws SdkBaseException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     * 
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @sample ProtocolRestXmlClient.MapOfStringToListOfStringInQueryParams
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams() throws SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     * 
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @sample ProtocolRestXmlClient.MapOfStringToListOfStringInQueryParams
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInHeaders operation.
     * 
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @sample ProtocolRestXmlClient.MembersInHeaders
     */
    default MembersInHeadersResponse membersInHeaders() throws SdkBaseException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInHeaders operation.
     * 
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @sample ProtocolRestXmlClient.MembersInHeaders
     */
    default MembersInHeadersResponse membersInHeaders(MembersInHeadersRequest membersInHeadersRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInQueryParams operation.
     * 
     * @param membersInQueryParamsRequest
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @sample ProtocolRestXmlClient.MembersInQueryParams
     */
    default MembersInQueryParamsResponse membersInQueryParams() throws SdkBaseException, SdkClientException,
            ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInQueryParams operation.
     * 
     * @param membersInQueryParamsRequest
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @sample ProtocolRestXmlClient.MembersInQueryParams
     */
    default MembersInQueryParamsResponse membersInQueryParams(MembersInQueryParamsRequest membersInQueryParamsRequest)
            throws SdkBaseException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiLocationOperation operation.
     * 
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @sample ProtocolRestXmlClient.MultiLocationOperation
     */
    default MultiLocationOperationResponse multiLocationOperation(MultiLocationOperationRequest multiLocationOperationRequest)
            throws SdkBaseException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     * 
     * @param operationWithExplicitPayloadBlobRequest
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @sample ProtocolRestXmlClient.OperationWithExplicitPayloadBlob
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob() throws SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     * 
     * @param operationWithExplicitPayloadBlobRequest
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @sample ProtocolRestXmlClient.OperationWithExplicitPayloadBlob
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob(
            OperationWithExplicitPayloadBlobRequest operationWithExplicitPayloadBlobRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithGreedyLabel operation.
     * 
     * @param operationWithGreedyLabelRequest
     * @return Result of the OperationWithGreedyLabel operation returned by the service.
     * @sample ProtocolRestXmlClient.OperationWithGreedyLabel
     */
    default OperationWithGreedyLabelResponse operationWithGreedyLabel(
            OperationWithGreedyLabelRequest operationWithGreedyLabelRequest) throws SdkBaseException, SdkClientException,
            ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     * 
     * @param operationWithModeledContentTypeRequest
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @sample ProtocolRestXmlClient.OperationWithModeledContentType
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType() throws SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     * 
     * @param operationWithModeledContentTypeRequest
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @sample ProtocolRestXmlClient.OperationWithModeledContentType
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     * 
     * @param queryParamWithoutValueRequest
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @sample ProtocolRestXmlClient.QueryParamWithoutValue
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue() throws SdkBaseException, SdkClientException,
            ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     * 
     * @param queryParamWithoutValueRequest
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @sample ProtocolRestXmlClient.QueryParamWithoutValue
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue(QueryParamWithoutValueRequest queryParamWithoutValueRequest)
            throws SdkBaseException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the RestXmlTypes operation.
     * 
     * @param restXmlTypesRequest
     * @return Result of the RestXmlTypes operation returned by the service.
     * @sample ProtocolRestXmlClient.RestXmlTypes
     */
    default RestXmlTypesResponse restXmlTypes() throws SdkBaseException, SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the RestXmlTypes operation.
     * 
     * @param restXmlTypesRequest
     * @return Result of the RestXmlTypes operation returned by the service.
     * @sample ProtocolRestXmlClient.RestXmlTypes
     */
    default RestXmlTypesResponse restXmlTypes(RestXmlTypesRequest restXmlTypesRequest) throws SdkBaseException,
            SdkClientException, ProtocolRestXmlException {
        throw new UnsupportedOperationException();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("restxml");
    }
}
