/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2;

import javax.annotation.Generated;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocolec2.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolec2.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolec2.model.Ec2TypesRequest;
import software.amazon.awssdk.services.protocolec2.model.Ec2TypesResponse;
import software.amazon.awssdk.services.protocolec2.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolec2.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolec2.model.ProtocolEc2Exception;

/**
 * Service client for accessing AmazonProtocolEc2. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolEc2Client extends AutoCloseable {
    String SERVICE_NAME = "ec2";

    /**
     * Create a {@link ProtocolEc2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static ProtocolEc2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolEc2Client}.
     */
    static ProtocolEc2ClientBuilder builder() {
        return new DefaultProtocolEc2ClientBuilder();
    }

    /**
     * Invokes the AllTypes operation.
     * 
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @sample ProtocolEc2Client.AllTypes
     */
    default AllTypesResponse allTypes() throws SdkBaseException, SdkClientException, ProtocolEc2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation.
     * 
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @sample ProtocolEc2Client.AllTypes
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws SdkBaseException, SdkClientException,
            ProtocolEc2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the Ec2Types operation.
     * 
     * @param ec2TypesRequest
     * @return Result of the Ec2Types operation returned by the service.
     * @sample ProtocolEc2Client.Ec2Types
     */
    default Ec2TypesResponse ec2Types() throws SdkBaseException, SdkClientException, ProtocolEc2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the Ec2Types operation.
     * 
     * @param ec2TypesRequest
     * @return Result of the Ec2Types operation returned by the service.
     * @sample ProtocolEc2Client.Ec2Types
     */
    default Ec2TypesResponse ec2Types(Ec2TypesRequest ec2TypesRequest) throws SdkBaseException, SdkClientException,
            ProtocolEc2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation.
     * 
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @sample ProtocolEc2Client.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation() throws SdkBaseException, SdkClientException, ProtocolEc2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation.
     * 
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @sample ProtocolEc2Client.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws SdkBaseException, SdkClientException, ProtocolEc2Exception {
        throw new UnsupportedOperationException();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("ec2");
    }
}
