/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SomeModeledException extends ApiGatewayProtocolException implements
        ToCopyableBuilder<SomeModeledException.Builder, SomeModeledException> {
    private final String resourceName;

    private SomeModeledException(BuilderImpl builder) {
        super(builder.message);
        this.resourceName = builder.resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ResourceName property for this object.
     * 
     * @return The value of the ResourceName property for this object.
     */
    public String resourceName() {
        return resourceName;
    }

    public interface Builder extends CopyableBuilder<Builder, SomeModeledException> {
        /**
         * Sets the value of the ResourceName property for this object.
         *
         * @param resourceName
         *        The new value for the ResourceName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(SomeModeledException model) {
            setResourceName(model.resourceName);
            this.message = model.getMessage();
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @JsonProperty("resourceName")
        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public SomeModeledException build() {
            return new SomeModeledException(this);
        }
    }
}
