/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MultiPathParamOperationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<MultiPathParamOperationRequest.Builder, MultiPathParamOperationRequest> {
    private final String pathMemberOne;

    private final String pathMemberTwo;

    private MultiPathParamOperationRequest(BuilderImpl builder) {
        this.pathMemberOne = builder.pathMemberOne;
        this.pathMemberTwo = builder.pathMemberTwo;
    }

    /**
     * Returns the value of the PathMemberOne property for this object.
     * 
     * @return The value of the PathMemberOne property for this object.
     */
    public String pathMemberOne() {
        return pathMemberOne;
    }

    /**
     * Returns the value of the PathMemberTwo property for this object.
     * 
     * @return The value of the PathMemberTwo property for this object.
     */
    public String pathMemberTwo() {
        return pathMemberTwo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((pathMemberOne() == null) ? 0 : pathMemberOne().hashCode());
        hashCode = 31 * hashCode + ((pathMemberTwo() == null) ? 0 : pathMemberTwo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiPathParamOperationRequest)) {
            return false;
        }
        MultiPathParamOperationRequest other = (MultiPathParamOperationRequest) obj;
        if (other.pathMemberOne() == null ^ this.pathMemberOne() == null) {
            return false;
        }
        if (other.pathMemberOne() != null && !other.pathMemberOne().equals(this.pathMemberOne())) {
            return false;
        }
        if (other.pathMemberTwo() == null ^ this.pathMemberTwo() == null) {
            return false;
        }
        if (other.pathMemberTwo() != null && !other.pathMemberTwo().equals(this.pathMemberTwo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (pathMemberOne() != null) {
            sb.append("PathMemberOne: ").append(pathMemberOne()).append(",");
        }
        if (pathMemberTwo() != null) {
            sb.append("PathMemberTwo: ").append(pathMemberTwo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MultiPathParamOperationRequest> {
        /**
         * Sets the value of the PathMemberOne property for this object.
         *
         * @param pathMemberOne
         *        The new value for the PathMemberOne property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathMemberOne(String pathMemberOne);

        /**
         * Sets the value of the PathMemberTwo property for this object.
         *
         * @param pathMemberTwo
         *        The new value for the PathMemberTwo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathMemberTwo(String pathMemberTwo);
    }

    private static final class BuilderImpl implements Builder {
        private String pathMemberOne;

        private String pathMemberTwo;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiPathParamOperationRequest model) {
            setPathMemberOne(model.pathMemberOne);
            setPathMemberTwo(model.pathMemberTwo);
        }

        public final String getPathMemberOne() {
            return pathMemberOne;
        }

        @Override
        public final Builder pathMemberOne(String pathMemberOne) {
            this.pathMemberOne = pathMemberOne;
            return this;
        }

        public final void setPathMemberOne(String pathMemberOne) {
            this.pathMemberOne = pathMemberOne;
        }

        public final String getPathMemberTwo() {
            return pathMemberTwo;
        }

        @Override
        public final Builder pathMemberTwo(String pathMemberTwo) {
            this.pathMemberTwo = pathMemberTwo;
            return this;
        }

        public final void setPathMemberTwo(String pathMemberTwo) {
            this.pathMemberTwo = pathMemberTwo;
        }

        @Override
        public MultiPathParamOperationRequest build() {
            return new MultiPathParamOperationRequest(this);
        }
    }
}
