/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol;

import java.util.Arrays;
import javax.annotation.Generated;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.AllTypesRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.AllTypesResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.ApiGatewayProtocolException;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.GetScalarsRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.GetScalarsResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MembersInHeadersRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MembersInHeadersResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MultiLocationOperationRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MultiLocationOperationResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MultiPathParamOperationRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MultiPathParamOperationResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.NoModeledExceptionsRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.NoModeledExceptionsResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.PutScalarsRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.PutScalarsResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SameShapeDifferentStatusCodesRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SameShapeDifferentStatusCodesResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SomeModeledException;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.AllTypesRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.AllTypesResponseUnmarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.GetScalarsRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.GetScalarsResponseUnmarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.MembersInHeadersRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.MembersInHeadersResponseUnmarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.MultiLocationOperationRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.MultiLocationOperationResponseUnmarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.MultiPathParamOperationRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.MultiPathParamOperationResponseUnmarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.NoModeledExceptionsRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.NoModeledExceptionsResponseUnmarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.OperationWithNoInputOrOutputRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.OperationWithNoInputOrOutputResponseUnmarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.PutScalarsRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.PutScalarsResponseUnmarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.SameShapeDifferentStatusCodesRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.SameShapeDifferentStatusCodesResponseUnmarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.SharedExceptionsAcrossOperationsWithDifferentStatusCodesRequestMarshaller;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponseUnmarshaller;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.opensdk.protect.client.SdkClientHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;

/**
 * Internal implementation of {@link ApiGatewayProtocolClient}.
 *
 * @see ApiGatewayProtocolClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultApiGatewayProtocolClient implements ApiGatewayProtocolClient {
    private final ClientHandler clientHandler;

    private final software.amazon.awssdk.opensdk.protect.protocol.ApiGatewayProtocolFactoryImpl protocolFactory;

    private final AwsSyncClientParams clientParams;

    protected DefaultApiGatewayProtocolClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams)
                .withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = init();
    }

    /**
     * Invokes the AllTypes operation.
     * 
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @sample ApiGatewayProtocolClient.AllTypes
     */
    @Override
    public AllTypesResponse allTypes() throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the AllTypes operation.
     * 
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @sample ApiGatewayProtocolClient.AllTypes
     */
    @Override
    public AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {

        HttpResponseHandler<AllTypesResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new AllTypesResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AllTypesRequest, AllTypesResponse>()
                .withMarshaller(new AllTypesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(allTypesRequest));
    }

    /**
     * Invokes the GetScalars operation.
     * 
     * @param getScalarsRequest
     * @return Result of the GetScalars operation returned by the service.
     * @sample ApiGatewayProtocolClient.GetScalars
     */
    @Override
    public GetScalarsResponse getScalars() throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        return getScalars(GetScalarsRequest.builder().build());
    }

    /**
     * Invokes the GetScalars operation.
     * 
     * @param getScalarsRequest
     * @return Result of the GetScalars operation returned by the service.
     * @sample ApiGatewayProtocolClient.GetScalars
     */
    @Override
    public GetScalarsResponse getScalars(GetScalarsRequest getScalarsRequest) throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {

        HttpResponseHandler<GetScalarsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetScalarsResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetScalarsRequest, GetScalarsResponse>()
                .withMarshaller(new GetScalarsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getScalarsRequest));
    }

    /**
     * Invokes the MembersInHeaders operation.
     * 
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @sample ApiGatewayProtocolClient.MembersInHeaders
     */
    @Override
    public MembersInHeadersResponse membersInHeaders() throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        return membersInHeaders(MembersInHeadersRequest.builder().build());
    }

    /**
     * Invokes the MembersInHeaders operation.
     * 
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @sample ApiGatewayProtocolClient.MembersInHeaders
     */
    @Override
    public MembersInHeadersResponse membersInHeaders(MembersInHeadersRequest membersInHeadersRequest) throws SdkBaseException,
            SdkClientException, ApiGatewayProtocolException {

        HttpResponseHandler<MembersInHeadersResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new MembersInHeadersResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<MembersInHeadersRequest, MembersInHeadersResponse>()
                .withMarshaller(new MembersInHeadersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(membersInHeadersRequest));
    }

    /**
     * Invokes the MultiLocationOperation operation.
     * 
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @sample ApiGatewayProtocolClient.MultiLocationOperation
     */
    @Override
    public MultiLocationOperationResponse multiLocationOperation() throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        return multiLocationOperation(MultiLocationOperationRequest.builder().build());
    }

    /**
     * Invokes the MultiLocationOperation operation.
     * 
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @sample ApiGatewayProtocolClient.MultiLocationOperation
     */
    @Override
    public MultiLocationOperationResponse multiLocationOperation(MultiLocationOperationRequest multiLocationOperationRequest)
            throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {

        HttpResponseHandler<MultiLocationOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new MultiLocationOperationResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<MultiLocationOperationRequest, MultiLocationOperationResponse>()
                .withMarshaller(new MultiLocationOperationRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(multiLocationOperationRequest));
    }

    /**
     * Invokes the MultiPathParamOperation operation.
     * 
     * @param multiPathParamOperationRequest
     * @return Result of the MultiPathParamOperation operation returned by the service.
     * @sample ApiGatewayProtocolClient.MultiPathParamOperation
     */
    @Override
    public MultiPathParamOperationResponse multiPathParamOperation() throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        return multiPathParamOperation(MultiPathParamOperationRequest.builder().build());
    }

    /**
     * Invokes the MultiPathParamOperation operation.
     * 
     * @param multiPathParamOperationRequest
     * @return Result of the MultiPathParamOperation operation returned by the service.
     * @sample ApiGatewayProtocolClient.MultiPathParamOperation
     */
    @Override
    public MultiPathParamOperationResponse multiPathParamOperation(MultiPathParamOperationRequest multiPathParamOperationRequest)
            throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {

        HttpResponseHandler<MultiPathParamOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new MultiPathParamOperationResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<MultiPathParamOperationRequest, MultiPathParamOperationResponse>()
                .withMarshaller(new MultiPathParamOperationRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(multiPathParamOperationRequest));
    }

    /**
     * Invokes the NoModeledExceptions operation.
     * 
     * @param noModeledExceptionsRequest
     * @return Result of the NoModeledExceptions operation returned by the service.
     * @sample ApiGatewayProtocolClient.NoModeledExceptions
     */
    @Override
    public NoModeledExceptionsResponse noModeledExceptions() throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        return noModeledExceptions(NoModeledExceptionsRequest.builder().build());
    }

    /**
     * Invokes the NoModeledExceptions operation.
     * 
     * @param noModeledExceptionsRequest
     * @return Result of the NoModeledExceptions operation returned by the service.
     * @sample ApiGatewayProtocolClient.NoModeledExceptions
     */
    @Override
    public NoModeledExceptionsResponse noModeledExceptions(NoModeledExceptionsRequest noModeledExceptionsRequest)
            throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {

        HttpResponseHandler<NoModeledExceptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new NoModeledExceptionsResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<NoModeledExceptionsRequest, NoModeledExceptionsResponse>()
                .withMarshaller(new NoModeledExceptionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(noModeledExceptionsRequest));
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     * 
     * @param operationWithNoInputOrOutputRequest
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @sample ApiGatewayProtocolClient.OperationWithNoInputOrOutput
     */
    @Override
    public OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput() throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder().build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     * 
     * @param operationWithNoInputOrOutputRequest
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @sample ApiGatewayProtocolClient.OperationWithNoInputOrOutput
     */
    @Override
    public OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {

        HttpResponseHandler<OperationWithNoInputOrOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new OperationWithNoInputOrOutputResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<OperationWithNoInputOrOutputRequest, OperationWithNoInputOrOutputResponse>()
                        .withMarshaller(new OperationWithNoInputOrOutputRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(operationWithNoInputOrOutputRequest));
    }

    /**
     * Invokes the PutScalars operation.
     * 
     * @param putScalarsRequest
     * @return Result of the PutScalars operation returned by the service.
     * @sample ApiGatewayProtocolClient.PutScalars
     */
    @Override
    public PutScalarsResponse putScalars() throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        return putScalars(PutScalarsRequest.builder().build());
    }

    /**
     * Invokes the PutScalars operation.
     * 
     * @param putScalarsRequest
     * @return Result of the PutScalars operation returned by the service.
     * @sample ApiGatewayProtocolClient.PutScalars
     */
    @Override
    public PutScalarsResponse putScalars(PutScalarsRequest putScalarsRequest) throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {

        HttpResponseHandler<PutScalarsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutScalarsResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutScalarsRequest, PutScalarsResponse>()
                .withMarshaller(new PutScalarsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putScalarsRequest));
    }

    /**
     * Invokes the SameShapeDifferentStatusCodes operation.
     * 
     * @param sameShapeDifferentStatusCodesRequest
     * @return Result of the SameShapeDifferentStatusCodes operation returned by the service.
     * @throws SomeModeledException
     * @throws SomeModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ApiGatewayProtocolException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ApiGatewayProtocolClient.SameShapeDifferentStatusCodes
     */
    @Override
    public SameShapeDifferentStatusCodesResponse sameShapeDifferentStatusCodes() throws SomeModeledException, SdkBaseException,
            SdkClientException, ApiGatewayProtocolException {
        return sameShapeDifferentStatusCodes(SameShapeDifferentStatusCodesRequest.builder().build());
    }

    /**
     * Invokes the SameShapeDifferentStatusCodes operation.
     * 
     * @param sameShapeDifferentStatusCodesRequest
     * @return Result of the SameShapeDifferentStatusCodes operation returned by the service.
     * @throws SomeModeledException
     * @throws SomeModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ApiGatewayProtocolException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ApiGatewayProtocolClient.SameShapeDifferentStatusCodes
     */
    @Override
    public SameShapeDifferentStatusCodesResponse sameShapeDifferentStatusCodes(
            SameShapeDifferentStatusCodesRequest sameShapeDifferentStatusCodesRequest) throws SomeModeledException,
            SdkBaseException, SdkClientException, ApiGatewayProtocolException {

        HttpResponseHandler<SameShapeDifferentStatusCodesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new SameShapeDifferentStatusCodesResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler(new JsonErrorShapeMetadata()
                .withModeledClass(SomeModeledException.class).withHttpStatusCode(404), new JsonErrorShapeMetadata()
                .withModeledClass(SomeModeledException.class).withHttpStatusCode(500));

        return clientHandler
                .execute(new ClientExecutionParams<SameShapeDifferentStatusCodesRequest, SameShapeDifferentStatusCodesResponse>()
                        .withMarshaller(new SameShapeDifferentStatusCodesRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(sameShapeDifferentStatusCodesRequest));
    }

    /**
     * Invokes the SharedExceptionsAcrossOperationsWithDifferentStatusCodes operation.
     * 
     * @param sharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest
     * @return Result of the SharedExceptionsAcrossOperationsWithDifferentStatusCodes operation returned by the service.
     * @throws SomeModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ApiGatewayProtocolException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ApiGatewayProtocolClient.SharedExceptionsAcrossOperationsWithDifferentStatusCodes
     */
    @Override
    public SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponse sharedExceptionsAcrossOperationsWithDifferentStatusCodes()
            throws SomeModeledException, SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        return sharedExceptionsAcrossOperationsWithDifferentStatusCodes(SharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest
                .builder().build());
    }

    /**
     * Invokes the SharedExceptionsAcrossOperationsWithDifferentStatusCodes operation.
     * 
     * @param sharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest
     * @return Result of the SharedExceptionsAcrossOperationsWithDifferentStatusCodes operation returned by the service.
     * @throws SomeModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ApiGatewayProtocolException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ApiGatewayProtocolClient.SharedExceptionsAcrossOperationsWithDifferentStatusCodes
     */
    @Override
    public SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponse sharedExceptionsAcrossOperationsWithDifferentStatusCodes(
            SharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest sharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest)
            throws SomeModeledException, SdkBaseException, SdkClientException, ApiGatewayProtocolException {

        HttpResponseHandler<SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponse> responseHandler = protocolFactory
                .createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                        new SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponseUnmarshaller());

        HttpResponseHandler<SdkBaseException> errorResponseHandler = createErrorResponseHandler(new JsonErrorShapeMetadata()
                .withModeledClass(SomeModeledException.class).withHttpStatusCode(413));

        return clientHandler
                .execute(new ClientExecutionParams<SharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest, SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponse>()
                        .withMarshaller(
                                new SharedExceptionsAcrossOperationsWithDifferentStatusCodesRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(sharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest));
    }

    private HttpResponseHandler<SdkBaseException> createErrorResponseHandler(JsonErrorShapeMetadata... errorShapeMetadata) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata().withErrorShapes(Arrays
                .asList(errorShapeMetadata)));
    }

    private software.amazon.awssdk.opensdk.protect.protocol.ApiGatewayProtocolFactoryImpl init() {
        return new software.amazon.awssdk.opensdk.protect.protocol.ApiGatewayProtocolFactoryImpl(new JsonClientMetadata()
                .withProtocolVersion("1.1")
                .withSupportsCbor(false)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(
                        software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.ApiGatewayProtocolException.class)
                .withContentTypeOverride("application/json"));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }
}
