/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlOperationMetadata;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.EmptyModeledException;
import software.amazon.awssdk.services.protocolrestxml.model.ExplicitPayloadAndHeadersException;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.ImplicitPayloadException;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeResponse;
import software.amazon.awssdk.services.protocolrestxml.model.ProtocolRestXmlException;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueRequest;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueResponse;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesResponse;
import software.amazon.awssdk.services.protocolrestxml.transform.AllTypesRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.DeleteOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.IdempotentOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MapOfStringToListOfStringInQueryParamsRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInHeadersRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInQueryParamsRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MultiLocationOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithExplicitPayloadBlobRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithGreedyLabelRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithModeledContentTypeRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.QueryParamWithoutValueRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.RestXmlTypesRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ProtocolRestXmlAsyncClient}.
 *
 * @see ProtocolRestXmlAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultProtocolRestXmlAsyncClient implements ProtocolRestXmlAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultProtocolRestXmlAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsXmlProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultProtocolRestXmlAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     *
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>ExplicitPayloadAndHeadersException</li>
     *         <li>ImplicitPayloadException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.AllTypes
     */
    @Override
    public CompletableFuture<AllTypesResponse> allTypes(AllTypesRequest allTypesRequest) {
        try {

            HttpResponseHandler<AllTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    AllTypesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<AllTypesRequest, AllTypesResponse>()
                    .withMarshaller(new AllTypesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(allTypesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteOperation operation asynchronously.
     *
     * @param deleteOperationRequest
     * @return A Java Future containing the result of the DeleteOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.DeleteOperation
     */
    @Override
    public CompletableFuture<DeleteOperationResponse> deleteOperation(DeleteOperationRequest deleteOperationRequest) {
        try {

            HttpResponseHandler<DeleteOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                    DeleteOperationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteOperationRequest, DeleteOperationResponse>()
                    .withMarshaller(new DeleteOperationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteOperationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.
     *
     * @param idempotentOperationRequest
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.IdempotentOperation
     */
    @Override
    public CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            IdempotentOperationRequest idempotentOperationRequest) {
        try {

            HttpResponseHandler<IdempotentOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                    IdempotentOperationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<IdempotentOperationRequest, IdempotentOperationResponse>()
                    .withMarshaller(new IdempotentOperationRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(idempotentOperationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation asynchronously.
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return A Java Future containing the result of the MapOfStringToListOfStringInQueryParams operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.MapOfStringToListOfStringInQueryParams
     */
    @Override
    public CompletableFuture<MapOfStringToListOfStringInQueryParamsResponse> mapOfStringToListOfStringInQueryParams(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest) {
        try {

            HttpResponseHandler<MapOfStringToListOfStringInQueryParamsResponse> responseHandler = protocolFactory
                    .createResponseHandler(MapOfStringToListOfStringInQueryParamsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<MapOfStringToListOfStringInQueryParamsRequest, MapOfStringToListOfStringInQueryParamsResponse>()
                            .withMarshaller(new MapOfStringToListOfStringInQueryParamsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(mapOfStringToListOfStringInQueryParamsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the MembersInHeaders operation asynchronously.
     *
     * @param membersInHeadersRequest
     * @return A Java Future containing the result of the MembersInHeaders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.MembersInHeaders
     */
    @Override
    public CompletableFuture<MembersInHeadersResponse> membersInHeaders(MembersInHeadersRequest membersInHeadersRequest) {
        try {

            HttpResponseHandler<MembersInHeadersResponse> responseHandler = protocolFactory.createResponseHandler(
                    MembersInHeadersResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<MembersInHeadersRequest, MembersInHeadersResponse>()
                    .withMarshaller(new MembersInHeadersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(membersInHeadersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the MembersInQueryParams operation asynchronously.
     *
     * @param membersInQueryParamsRequest
     * @return A Java Future containing the result of the MembersInQueryParams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.MembersInQueryParams
     */
    @Override
    public CompletableFuture<MembersInQueryParamsResponse> membersInQueryParams(
            MembersInQueryParamsRequest membersInQueryParamsRequest) {
        try {

            HttpResponseHandler<MembersInQueryParamsResponse> responseHandler = protocolFactory.createResponseHandler(
                    MembersInQueryParamsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<MembersInQueryParamsRequest, MembersInQueryParamsResponse>()
                    .withMarshaller(new MembersInQueryParamsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(membersInQueryParamsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the MultiLocationOperation operation asynchronously.
     *
     * @param multiLocationOperationRequest
     * @return A Java Future containing the result of the MultiLocationOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.MultiLocationOperation
     */
    @Override
    public CompletableFuture<MultiLocationOperationResponse> multiLocationOperation(
            MultiLocationOperationRequest multiLocationOperationRequest) {
        try {

            HttpResponseHandler<MultiLocationOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                    MultiLocationOperationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<MultiLocationOperationRequest, MultiLocationOperationResponse>()
                            .withMarshaller(new MultiLocationOperationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(multiLocationOperationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation asynchronously.
     *
     * @param operationWithExplicitPayloadBlobRequest
     * @return A Java Future containing the result of the OperationWithExplicitPayloadBlob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.OperationWithExplicitPayloadBlob
     */
    @Override
    public CompletableFuture<OperationWithExplicitPayloadBlobResponse> operationWithExplicitPayloadBlob(
            OperationWithExplicitPayloadBlobRequest operationWithExplicitPayloadBlobRequest) {
        try {

            HttpResponseHandler<OperationWithExplicitPayloadBlobResponse> responseHandler = protocolFactory
                    .createResponseHandler(OperationWithExplicitPayloadBlobResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<OperationWithExplicitPayloadBlobRequest, OperationWithExplicitPayloadBlobResponse>()
                            .withMarshaller(new OperationWithExplicitPayloadBlobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(operationWithExplicitPayloadBlobRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the OperationWithGreedyLabel operation asynchronously.
     *
     * @param operationWithGreedyLabelRequest
     * @return A Java Future containing the result of the OperationWithGreedyLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.OperationWithGreedyLabel
     */
    @Override
    public CompletableFuture<OperationWithGreedyLabelResponse> operationWithGreedyLabel(
            OperationWithGreedyLabelRequest operationWithGreedyLabelRequest) {
        try {

            HttpResponseHandler<OperationWithGreedyLabelResponse> responseHandler = protocolFactory.createResponseHandler(
                    OperationWithGreedyLabelResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<OperationWithGreedyLabelRequest, OperationWithGreedyLabelResponse>()
                            .withMarshaller(new OperationWithGreedyLabelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(operationWithGreedyLabelRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the OperationWithModeledContentType operation asynchronously.
     *
     * @param operationWithModeledContentTypeRequest
     * @return A Java Future containing the result of the OperationWithModeledContentType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.OperationWithModeledContentType
     */
    @Override
    public CompletableFuture<OperationWithModeledContentTypeResponse> operationWithModeledContentType(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) {
        try {

            HttpResponseHandler<OperationWithModeledContentTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    OperationWithModeledContentTypeResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<OperationWithModeledContentTypeRequest, OperationWithModeledContentTypeResponse>()
                            .withMarshaller(new OperationWithModeledContentTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(operationWithModeledContentTypeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the QueryParamWithoutValue operation asynchronously.
     *
     * @param queryParamWithoutValueRequest
     * @return A Java Future containing the result of the QueryParamWithoutValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.QueryParamWithoutValue
     */
    @Override
    public CompletableFuture<QueryParamWithoutValueResponse> queryParamWithoutValue(
            QueryParamWithoutValueRequest queryParamWithoutValueRequest) {
        try {

            HttpResponseHandler<QueryParamWithoutValueResponse> responseHandler = protocolFactory.createResponseHandler(
                    QueryParamWithoutValueResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<QueryParamWithoutValueRequest, QueryParamWithoutValueResponse>()
                            .withMarshaller(new QueryParamWithoutValueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(queryParamWithoutValueRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the RestXmlTypes operation asynchronously.
     *
     * @param restXmlTypesRequest
     * @return A Java Future containing the result of the RestXmlTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestXmlException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestXmlAsyncClient.RestXmlTypes
     */
    @Override
    public CompletableFuture<RestXmlTypesResponse> restXmlTypes(RestXmlTypesRequest restXmlTypesRequest) {
        try {

            HttpResponseHandler<RestXmlTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    RestXmlTypesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<RestXmlTypesRequest, RestXmlTypesResponse>()
                    .withMarshaller(new RestXmlTypesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(restXmlTypesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExplicitPayloadAndHeadersException")
                                .exceptionBuilderSupplier(ExplicitPayloadAndHeadersException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ImplicitPayloadException")
                                .exceptionBuilderSupplier(ImplicitPayloadException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EmptyModeledException")
                                .exceptionBuilderSupplier(EmptyModeledException::builder).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(ProtocolRestXmlException::builder)
                .build();
    }
}
