/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.protocolrestjson.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolrestjson.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolrestjson.model.DeleteOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.DeleteOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.FurtherNestedContainersRequest;
import software.amazon.awssdk.services.protocolrestjson.model.FurtherNestedContainersResponse;
import software.amazon.awssdk.services.protocolrestjson.model.GetOperationWithBodyRequest;
import software.amazon.awssdk.services.protocolrestjson.model.GetOperationWithBodyResponse;
import software.amazon.awssdk.services.protocolrestjson.model.HeadOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.HeadOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.JsonValuesOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.JsonValuesOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MapOfStringToListOfStringInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MapOfStringToListOfStringInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInHeadersRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInHeadersResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MultiLocationOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MultiLocationOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.NestedContainersRequest;
import software.amazon.awssdk.services.protocolrestjson.model.NestedContainersResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadBlobRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadBlobResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadStructureRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadStructureResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithGreedyLabelRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithGreedyLabelResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithModeledContentTypeRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithModeledContentTypeResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.services.protocolrestjson.model.QueryParamWithoutValueRequest;
import software.amazon.awssdk.services.protocolrestjson.model.QueryParamWithoutValueResponse;
import software.amazon.awssdk.services.protocolrestjson.model.StatusCodeInOutputOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.StatusCodeInOutputOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingInputOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingInputOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingOutputOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingOutputOperationResponse;

/**
 * Service client for accessing RestJsonProtocolTests asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolRestJsonAsyncClient extends SdkClient {
    String SERVICE_NAME = "restjson";

    /**
     * Create a {@link ProtocolRestJsonAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ProtocolRestJsonAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolRestJsonAsyncClient}.
     */
    static ProtocolRestJsonAsyncClientBuilder builder() {
        return new DefaultProtocolRestJsonAsyncClientBuilder();
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     *
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>ExplicitPayloadAndHeadersException</li>
     *         <li>ImplicitPayloadException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllTypesResponse> allTypes(AllTypesRequest allTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllTypesRequest.Builder} avoiding the need to
     * create one manually via {@link AllTypesRequest#builder()}
     * </p>
     *
     * @param allTypesRequest
     *        A {@link Consumer} that will call methods on {@link AllTypesStructure.Builder} to create a request.
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>ExplicitPayloadAndHeadersException</li>
     *         <li>ImplicitPayloadException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllTypesResponse> allTypes(Consumer<AllTypesRequest.Builder> allTypesRequest) {
        return allTypes(AllTypesRequest.builder().applyMutation(allTypesRequest).build());
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     *
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>ExplicitPayloadAndHeadersException</li>
     *         <li>ImplicitPayloadException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllTypesResponse> allTypes() {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the DeleteOperation operation asynchronously.
     *
     * @param deleteOperationRequest
     * @return A Java Future containing the result of the DeleteOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.DeleteOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOperationResponse> deleteOperation(DeleteOperationRequest deleteOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOperationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOperationRequest#builder()}
     * </p>
     *
     * @param deleteOperationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOperationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.DeleteOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOperationResponse> deleteOperation(
            Consumer<DeleteOperationRequest.Builder> deleteOperationRequest) {
        return deleteOperation(DeleteOperationRequest.builder().applyMutation(deleteOperationRequest).build());
    }

    /**
     * Invokes the DeleteOperation operation asynchronously.
     *
     * @return A Java Future containing the result of the DeleteOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.DeleteOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOperationResponse> deleteOperation() {
        return deleteOperation(DeleteOperationRequest.builder().build());
    }

    /**
     * Invokes the FurtherNestedContainers operation asynchronously.
     *
     * @param furtherNestedContainersRequest
     * @return A Java Future containing the result of the FurtherNestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.FurtherNestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/FurtherNestedContainers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<FurtherNestedContainersResponse> furtherNestedContainers(
            FurtherNestedContainersRequest furtherNestedContainersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the FurtherNestedContainers operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FurtherNestedContainersRequest.Builder} avoiding
     * the need to create one manually via {@link FurtherNestedContainersRequest#builder()}
     * </p>
     *
     * @param furtherNestedContainersRequest
     *        A {@link Consumer} that will call methods on {@link FurtherNestedContainersStructure.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the FurtherNestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.FurtherNestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/FurtherNestedContainers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<FurtherNestedContainersResponse> furtherNestedContainers(
            Consumer<FurtherNestedContainersRequest.Builder> furtherNestedContainersRequest) {
        return furtherNestedContainers(FurtherNestedContainersRequest.builder().applyMutation(furtherNestedContainersRequest)
                .build());
    }

    /**
     * Invokes the FurtherNestedContainers operation asynchronously.
     *
     * @return A Java Future containing the result of the FurtherNestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.FurtherNestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/FurtherNestedContainers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<FurtherNestedContainersResponse> furtherNestedContainers() {
        return furtherNestedContainers(FurtherNestedContainersRequest.builder().build());
    }

    /**
     * Invokes the GetOperationWithBody operation asynchronously.
     *
     * @param getOperationWithBodyRequest
     * @return A Java Future containing the result of the GetOperationWithBody operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.GetOperationWithBody
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/GetOperationWithBody" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOperationWithBodyResponse> getOperationWithBody(
            GetOperationWithBodyRequest getOperationWithBodyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the GetOperationWithBody operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOperationWithBodyRequest.Builder} avoiding the
     * need to create one manually via {@link GetOperationWithBodyRequest#builder()}
     * </p>
     *
     * @param getOperationWithBodyRequest
     *        A {@link Consumer} that will call methods on {@link GetOperationWithBodyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOperationWithBody operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.GetOperationWithBody
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/GetOperationWithBody" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOperationWithBodyResponse> getOperationWithBody(
            Consumer<GetOperationWithBodyRequest.Builder> getOperationWithBodyRequest) {
        return getOperationWithBody(GetOperationWithBodyRequest.builder().applyMutation(getOperationWithBodyRequest).build());
    }

    /**
     * Invokes the GetOperationWithBody operation asynchronously.
     *
     * @return A Java Future containing the result of the GetOperationWithBody operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.GetOperationWithBody
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/GetOperationWithBody" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOperationWithBodyResponse> getOperationWithBody() {
        return getOperationWithBody(GetOperationWithBodyRequest.builder().build());
    }

    /**
     * Invokes the HeadOperation operation asynchronously.
     *
     * @param headOperationRequest
     * @return A Java Future containing the result of the HeadOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.HeadOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<HeadOperationResponse> headOperation(HeadOperationRequest headOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the HeadOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link HeadOperationRequest.Builder} avoiding the need to
     * create one manually via {@link HeadOperationRequest#builder()}
     * </p>
     *
     * @param headOperationRequest
     *        A {@link Consumer} that will call methods on {@link HeadOperationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the HeadOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.HeadOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<HeadOperationResponse> headOperation(Consumer<HeadOperationRequest.Builder> headOperationRequest) {
        return headOperation(HeadOperationRequest.builder().applyMutation(headOperationRequest).build());
    }

    /**
     * Invokes the HeadOperation operation asynchronously.
     *
     * @return A Java Future containing the result of the HeadOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.HeadOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<HeadOperationResponse> headOperation() {
        return headOperation(HeadOperationRequest.builder().build());
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.
     *
     * @param idempotentOperationRequest
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            IdempotentOperationRequest idempotentOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IdempotentOperationRequest.Builder} avoiding the
     * need to create one manually via {@link IdempotentOperationRequest#builder()}
     * </p>
     *
     * @param idempotentOperationRequest
     *        A {@link Consumer} that will call methods on {@link IdempotentOperationStructure.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            Consumer<IdempotentOperationRequest.Builder> idempotentOperationRequest) {
        return idempotentOperation(IdempotentOperationRequest.builder().applyMutation(idempotentOperationRequest).build());
    }

    /**
     * Invokes the JsonValuesOperation operation asynchronously.
     *
     * @param jsonValuesOperationRequest
     * @return A Java Future containing the result of the JsonValuesOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.JsonValuesOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<JsonValuesOperationResponse> jsonValuesOperation(
            JsonValuesOperationRequest jsonValuesOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the JsonValuesOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link JsonValuesOperationRequest.Builder} avoiding the
     * need to create one manually via {@link JsonValuesOperationRequest#builder()}
     * </p>
     *
     * @param jsonValuesOperationRequest
     *        A {@link Consumer} that will call methods on {@link JsonValuesStructure.Builder} to create a request.
     * @return A Java Future containing the result of the JsonValuesOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.JsonValuesOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<JsonValuesOperationResponse> jsonValuesOperation(
            Consumer<JsonValuesOperationRequest.Builder> jsonValuesOperationRequest) {
        return jsonValuesOperation(JsonValuesOperationRequest.builder().applyMutation(jsonValuesOperationRequest).build());
    }

    /**
     * Invokes the JsonValuesOperation operation asynchronously.
     *
     * @return A Java Future containing the result of the JsonValuesOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.JsonValuesOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<JsonValuesOperationResponse> jsonValuesOperation() {
        return jsonValuesOperation(JsonValuesOperationRequest.builder().build());
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation asynchronously.
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return A Java Future containing the result of the MapOfStringToListOfStringInQueryParams operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MapOfStringToListOfStringInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MapOfStringToListOfStringInQueryParamsResponse> mapOfStringToListOfStringInQueryParams(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link MapOfStringToListOfStringInQueryParamsRequest.Builder} avoiding the need to create one manually via
     * {@link MapOfStringToListOfStringInQueryParamsRequest#builder()}
     * </p>
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     *        A {@link Consumer} that will call methods on {@link MapOfStringToListOfStringInQueryParamsInput.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the MapOfStringToListOfStringInQueryParams operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MapOfStringToListOfStringInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MapOfStringToListOfStringInQueryParamsResponse> mapOfStringToListOfStringInQueryParams(
            Consumer<MapOfStringToListOfStringInQueryParamsRequest.Builder> mapOfStringToListOfStringInQueryParamsRequest) {
        return mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest.builder()
                .applyMutation(mapOfStringToListOfStringInQueryParamsRequest).build());
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation asynchronously.
     *
     * @return A Java Future containing the result of the MapOfStringToListOfStringInQueryParams operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MapOfStringToListOfStringInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MapOfStringToListOfStringInQueryParamsResponse> mapOfStringToListOfStringInQueryParams() {
        return mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the MembersInHeaders operation asynchronously.
     *
     * @param membersInHeadersRequest
     * @return A Java Future containing the result of the MembersInHeaders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInHeaders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MembersInHeadersResponse> membersInHeaders(MembersInHeadersRequest membersInHeadersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInHeaders operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MembersInHeadersRequest.Builder} avoiding the need
     * to create one manually via {@link MembersInHeadersRequest#builder()}
     * </p>
     *
     * @param membersInHeadersRequest
     *        A {@link Consumer} that will call methods on {@link MembersInHeadersStructure.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the MembersInHeaders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInHeaders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MembersInHeadersResponse> membersInHeaders(
            Consumer<MembersInHeadersRequest.Builder> membersInHeadersRequest) {
        return membersInHeaders(MembersInHeadersRequest.builder().applyMutation(membersInHeadersRequest).build());
    }

    /**
     * Invokes the MembersInHeaders operation asynchronously.
     *
     * @return A Java Future containing the result of the MembersInHeaders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInHeaders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MembersInHeadersResponse> membersInHeaders() {
        return membersInHeaders(MembersInHeadersRequest.builder().build());
    }

    /**
     * Invokes the MembersInQueryParams operation asynchronously.
     *
     * @param membersInQueryParamsRequest
     * @return A Java Future containing the result of the MembersInQueryParams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<MembersInQueryParamsResponse> membersInQueryParams(
            MembersInQueryParamsRequest membersInQueryParamsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInQueryParams operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MembersInQueryParamsRequest.Builder} avoiding the
     * need to create one manually via {@link MembersInQueryParamsRequest#builder()}
     * </p>
     *
     * @param membersInQueryParamsRequest
     *        A {@link Consumer} that will call methods on {@link MembersInQueryParamsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the MembersInQueryParams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<MembersInQueryParamsResponse> membersInQueryParams(
            Consumer<MembersInQueryParamsRequest.Builder> membersInQueryParamsRequest) {
        return membersInQueryParams(MembersInQueryParamsRequest.builder().applyMutation(membersInQueryParamsRequest).build());
    }

    /**
     * Invokes the MembersInQueryParams operation asynchronously.
     *
     * @return A Java Future containing the result of the MembersInQueryParams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<MembersInQueryParamsResponse> membersInQueryParams() {
        return membersInQueryParams(MembersInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the MultiLocationOperation operation asynchronously.
     *
     * @param multiLocationOperationRequest
     * @return A Java Future containing the result of the MultiLocationOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MultiLocationOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MultiLocationOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MultiLocationOperationResponse> multiLocationOperation(
            MultiLocationOperationRequest multiLocationOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiLocationOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MultiLocationOperationRequest.Builder} avoiding the
     * need to create one manually via {@link MultiLocationOperationRequest#builder()}
     * </p>
     *
     * @param multiLocationOperationRequest
     *        A {@link Consumer} that will call methods on {@link MultiLocationOperationInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the MultiLocationOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MultiLocationOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MultiLocationOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MultiLocationOperationResponse> multiLocationOperation(
            Consumer<MultiLocationOperationRequest.Builder> multiLocationOperationRequest) {
        return multiLocationOperation(MultiLocationOperationRequest.builder().applyMutation(multiLocationOperationRequest)
                .build());
    }

    /**
     * Invokes the NestedContainers operation asynchronously.
     *
     * @param nestedContainersRequest
     * @return A Java Future containing the result of the NestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<NestedContainersResponse> nestedContainers(NestedContainersRequest nestedContainersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the NestedContainers operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NestedContainersRequest.Builder} avoiding the need
     * to create one manually via {@link NestedContainersRequest#builder()}
     * </p>
     *
     * @param nestedContainersRequest
     *        A {@link Consumer} that will call methods on {@link NestedContainersStructure.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the NestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<NestedContainersResponse> nestedContainers(
            Consumer<NestedContainersRequest.Builder> nestedContainersRequest) {
        return nestedContainers(NestedContainersRequest.builder().applyMutation(nestedContainersRequest).build());
    }

    /**
     * Invokes the NestedContainers operation asynchronously.
     *
     * @return A Java Future containing the result of the NestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<NestedContainersResponse> nestedContainers() {
        return nestedContainers(NestedContainersRequest.builder().build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation asynchronously.
     *
     * @param operationWithExplicitPayloadBlobRequest
     * @return A Java Future containing the result of the OperationWithExplicitPayloadBlob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadBlobResponse> operationWithExplicitPayloadBlob(
            OperationWithExplicitPayloadBlobRequest operationWithExplicitPayloadBlobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithExplicitPayloadBlobRequest.Builder}
     * avoiding the need to create one manually via {@link OperationWithExplicitPayloadBlobRequest#builder()}
     * </p>
     *
     * @param operationWithExplicitPayloadBlobRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithExplicitPayloadBlobInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the OperationWithExplicitPayloadBlob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadBlobResponse> operationWithExplicitPayloadBlob(
            Consumer<OperationWithExplicitPayloadBlobRequest.Builder> operationWithExplicitPayloadBlobRequest) {
        return operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest.builder()
                .applyMutation(operationWithExplicitPayloadBlobRequest).build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation asynchronously.
     *
     * @return A Java Future containing the result of the OperationWithExplicitPayloadBlob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadBlobResponse> operationWithExplicitPayloadBlob() {
        return operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest.builder().build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation asynchronously.
     *
     * @param operationWithExplicitPayloadStructureRequest
     * @return A Java Future containing the result of the OperationWithExplicitPayloadStructure operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadStructure
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadStructureResponse> operationWithExplicitPayloadStructure(
            OperationWithExplicitPayloadStructureRequest operationWithExplicitPayloadStructureRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link OperationWithExplicitPayloadStructureRequest.Builder} avoiding the need to create one manually via
     * {@link OperationWithExplicitPayloadStructureRequest#builder()}
     * </p>
     *
     * @param operationWithExplicitPayloadStructureRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithExplicitPayloadStructureInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the OperationWithExplicitPayloadStructure operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadStructure
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadStructureResponse> operationWithExplicitPayloadStructure(
            Consumer<OperationWithExplicitPayloadStructureRequest.Builder> operationWithExplicitPayloadStructureRequest) {
        return operationWithExplicitPayloadStructure(OperationWithExplicitPayloadStructureRequest.builder()
                .applyMutation(operationWithExplicitPayloadStructureRequest).build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation asynchronously.
     *
     * @return A Java Future containing the result of the OperationWithExplicitPayloadStructure operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadStructure
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadStructureResponse> operationWithExplicitPayloadStructure() {
        return operationWithExplicitPayloadStructure(OperationWithExplicitPayloadStructureRequest.builder().build());
    }

    /**
     * Invokes the OperationWithGreedyLabel operation asynchronously.
     *
     * @param operationWithGreedyLabelRequest
     * @return A Java Future containing the result of the OperationWithGreedyLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithGreedyLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithGreedyLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithGreedyLabelResponse> operationWithGreedyLabel(
            OperationWithGreedyLabelRequest operationWithGreedyLabelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithGreedyLabel operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithGreedyLabelRequest.Builder} avoiding
     * the need to create one manually via {@link OperationWithGreedyLabelRequest#builder()}
     * </p>
     *
     * @param operationWithGreedyLabelRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithGreedyLabelInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the OperationWithGreedyLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithGreedyLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithGreedyLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithGreedyLabelResponse> operationWithGreedyLabel(
            Consumer<OperationWithGreedyLabelRequest.Builder> operationWithGreedyLabelRequest) {
        return operationWithGreedyLabel(OperationWithGreedyLabelRequest.builder().applyMutation(operationWithGreedyLabelRequest)
                .build());
    }

    /**
     * Invokes the OperationWithModeledContentType operation asynchronously.
     *
     * @param operationWithModeledContentTypeRequest
     * @return A Java Future containing the result of the OperationWithModeledContentType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithModeledContentType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithModeledContentTypeResponse> operationWithModeledContentType(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithModeledContentType operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithModeledContentTypeRequest.Builder}
     * avoiding the need to create one manually via {@link OperationWithModeledContentTypeRequest#builder()}
     * </p>
     *
     * @param operationWithModeledContentTypeRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithModeledContentTypeInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the OperationWithModeledContentType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithModeledContentType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithModeledContentTypeResponse> operationWithModeledContentType(
            Consumer<OperationWithModeledContentTypeRequest.Builder> operationWithModeledContentTypeRequest) {
        return operationWithModeledContentType(OperationWithModeledContentTypeRequest.builder()
                .applyMutation(operationWithModeledContentTypeRequest).build());
    }

    /**
     * Invokes the OperationWithModeledContentType operation asynchronously.
     *
     * @return A Java Future containing the result of the OperationWithModeledContentType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithModeledContentType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithModeledContentTypeResponse> operationWithModeledContentType() {
        return operationWithModeledContentType(OperationWithModeledContentTypeRequest.builder().build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation asynchronously.
     *
     * @param operationWithNoInputOrOutputRequest
     * @return A Java Future containing the result of the OperationWithNoInputOrOutput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithNoInputOrOutputResponse> operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithNoInputOrOutputRequest.Builder}
     * avoiding the need to create one manually via {@link OperationWithNoInputOrOutputRequest#builder()}
     * </p>
     *
     * @param operationWithNoInputOrOutputRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithNoInputOrOutputRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the OperationWithNoInputOrOutput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithNoInputOrOutputResponse> operationWithNoInputOrOutput(
            Consumer<OperationWithNoInputOrOutputRequest.Builder> operationWithNoInputOrOutputRequest) {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder()
                .applyMutation(operationWithNoInputOrOutputRequest).build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation asynchronously.
     *
     * @return A Java Future containing the result of the OperationWithNoInputOrOutput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithNoInputOrOutputResponse> operationWithNoInputOrOutput() {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder().build());
    }

    /**
     * Invokes the QueryParamWithoutValue operation asynchronously.
     *
     * @param queryParamWithoutValueRequest
     * @return A Java Future containing the result of the QueryParamWithoutValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.QueryParamWithoutValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<QueryParamWithoutValueResponse> queryParamWithoutValue(
            QueryParamWithoutValueRequest queryParamWithoutValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the QueryParamWithoutValue operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryParamWithoutValueRequest.Builder} avoiding the
     * need to create one manually via {@link QueryParamWithoutValueRequest#builder()}
     * </p>
     *
     * @param queryParamWithoutValueRequest
     *        A {@link Consumer} that will call methods on {@link QueryParamWithoutValueInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the QueryParamWithoutValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.QueryParamWithoutValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<QueryParamWithoutValueResponse> queryParamWithoutValue(
            Consumer<QueryParamWithoutValueRequest.Builder> queryParamWithoutValueRequest) {
        return queryParamWithoutValue(QueryParamWithoutValueRequest.builder().applyMutation(queryParamWithoutValueRequest)
                .build());
    }

    /**
     * Invokes the QueryParamWithoutValue operation asynchronously.
     *
     * @return A Java Future containing the result of the QueryParamWithoutValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.QueryParamWithoutValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<QueryParamWithoutValueResponse> queryParamWithoutValue() {
        return queryParamWithoutValue(QueryParamWithoutValueRequest.builder().build());
    }

    /**
     * Invokes the StatusCodeInOutputOperation operation asynchronously.
     *
     * @param statusCodeInOutputOperationRequest
     * @return A Java Future containing the result of the StatusCodeInOutputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StatusCodeInOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StatusCodeInOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StatusCodeInOutputOperationResponse> statusCodeInOutputOperation(
            StatusCodeInOutputOperationRequest statusCodeInOutputOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StatusCodeInOutputOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StatusCodeInOutputOperationRequest.Builder}
     * avoiding the need to create one manually via {@link StatusCodeInOutputOperationRequest#builder()}
     * </p>
     *
     * @param statusCodeInOutputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StatusCodeInOutputOperationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StatusCodeInOutputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StatusCodeInOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StatusCodeInOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StatusCodeInOutputOperationResponse> statusCodeInOutputOperation(
            Consumer<StatusCodeInOutputOperationRequest.Builder> statusCodeInOutputOperationRequest) {
        return statusCodeInOutputOperation(StatusCodeInOutputOperationRequest.builder()
                .applyMutation(statusCodeInOutputOperationRequest).build());
    }

    /**
     * Invokes the StatusCodeInOutputOperation operation asynchronously.
     *
     * @return A Java Future containing the result of the StatusCodeInOutputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StatusCodeInOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StatusCodeInOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StatusCodeInOutputOperationResponse> statusCodeInOutputOperation() {
        return statusCodeInOutputOperation(StatusCodeInOutputOperationRequest.builder().build());
    }

    /**
     * Invokes the StreamingInputOperation operation asynchronously.
     *
     * @param streamingInputOperationRequest
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows ''
     * @return A Java Future containing the result of the StreamingInputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingInputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StreamingInputOperationResponse> streamingInputOperation(
            StreamingInputOperationRequest streamingInputOperationRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StreamingInputOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingInputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingInputOperationRequest#builder()}
     * </p>
     *
     * @param streamingInputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StructureWithStreamingMember.Builder} to create a
     *        request.
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows ''
     * @return A Java Future containing the result of the StreamingInputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingInputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StreamingInputOperationResponse> streamingInputOperation(
            Consumer<StreamingInputOperationRequest.Builder> streamingInputOperationRequest, AsyncRequestBody requestBody) {
        return streamingInputOperation(StreamingInputOperationRequest.builder().applyMutation(streamingInputOperationRequest)
                .build(), requestBody);
    }

    /**
     * Invokes the StreamingInputOperation operation asynchronously.
     *
     * @param streamingInputOperationRequest
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows ''
     * @return A Java Future containing the result of the StreamingInputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingInputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StreamingInputOperationResponse> streamingInputOperation(
            StreamingInputOperationRequest streamingInputOperationRequest, Path sourcePath) {
        return streamingInputOperation(streamingInputOperationRequest, AsyncRequestBody.fromFile(sourcePath));
    }

    /**
     * Invokes the StreamingInputOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingInputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingInputOperationRequest#builder()}
     * </p>
     *
     * @param streamingInputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StructureWithStreamingMember.Builder} to create a
     *        request.
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows ''
     * @return A Java Future containing the result of the StreamingInputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingInputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StreamingInputOperationResponse> streamingInputOperation(
            Consumer<StreamingInputOperationRequest.Builder> streamingInputOperationRequest, Path sourcePath) {
        return streamingInputOperation(StreamingInputOperationRequest.builder().applyMutation(streamingInputOperationRequest)
                .build(), sourcePath);
    }

    /**
     * Invokes the StreamingOutputOperation operation asynchronously.
     *
     * @param streamingOutputOperationRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows ''.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> streamingOutputOperation(
            StreamingOutputOperationRequest streamingOutputOperationRequest,
            AsyncResponseTransformer<StreamingOutputOperationResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StreamingOutputOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingOutputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingOutputOperationRequest#builder()}
     * </p>
     *
     * @param streamingOutputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StreamingOutputOperationRequest.Builder} to create a
     *        request.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows ''.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> streamingOutputOperation(
            Consumer<StreamingOutputOperationRequest.Builder> streamingOutputOperationRequest,
            AsyncResponseTransformer<StreamingOutputOperationResponse, ReturnT> asyncResponseTransformer) {
        return streamingOutputOperation(StreamingOutputOperationRequest.builder().applyMutation(streamingOutputOperationRequest)
                .build(), asyncResponseTransformer);
    }

    /**
     * Invokes the StreamingOutputOperation operation asynchronously.
     *
     * @param streamingOutputOperationRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows ''.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StreamingOutputOperationResponse> streamingOutputOperation(
            StreamingOutputOperationRequest streamingOutputOperationRequest, Path destinationPath) {
        return streamingOutputOperation(streamingOutputOperationRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * Invokes the StreamingOutputOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingOutputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingOutputOperationRequest#builder()}
     * </p>
     *
     * @param streamingOutputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StreamingOutputOperationRequest.Builder} to create a
     *        request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows ''.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StreamingOutputOperationResponse> streamingOutputOperation(
            Consumer<StreamingOutputOperationRequest.Builder> streamingOutputOperationRequest, Path destinationPath) {
        return streamingOutputOperation(StreamingOutputOperationRequest.builder().applyMutation(streamingOutputOperationRequest)
                .build(), destinationPath);
    }
}
