/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolrestxml.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;

import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * AllTypesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AllTypesRequestMarshaller implements Marshaller<Request<AllTypesRequest>, AllTypesRequest> {

    public Request<AllTypesRequest> marshall(AllTypesRequest allTypesRequest) {

        if (allTypesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<AllTypesRequest> request = new DefaultRequest<AllTypesRequest>(allTypesRequest, "ProtocolRestXmlClient");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2016-03-11/allTypes";

        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://restxml/");

            xmlWriter.startElement("AllTypesRequest");

            if (allTypesRequest.stringMember() != null) {
                xmlWriter.startElement("stringMember").value(allTypesRequest.stringMember()).endElement();
            }

            if (allTypesRequest.integerMember() != null) {
                xmlWriter.startElement("integerMember").value(allTypesRequest.integerMember()).endElement();
            }

            if (allTypesRequest.booleanMember() != null) {
                xmlWriter.startElement("booleanMember").value(allTypesRequest.booleanMember()).endElement();
            }

            if (allTypesRequest.floatMember() != null) {
                xmlWriter.startElement("floatMember").value(allTypesRequest.floatMember()).endElement();
            }

            if (allTypesRequest.doubleMember() != null) {
                xmlWriter.startElement("doubleMember").value(allTypesRequest.doubleMember()).endElement();
            }

            if (allTypesRequest.longMember() != null) {
                xmlWriter.startElement("longMember").value(allTypesRequest.longMember()).endElement();
            }

            SimpleStruct simpleStructMember = allTypesRequest.simpleStructMember();
            if (simpleStructMember != null) {
                xmlWriter.startElement("simpleStructMember");

                if (simpleStructMember.stringMember() != null) {
                    xmlWriter.startElement("StringMember").value(simpleStructMember.stringMember()).endElement();
                }
                xmlWriter.endElement();
            }

            java.util.List<String> allTypesRequestSimpleListList = allTypesRequest.simpleList();
            if (!allTypesRequestSimpleListList.isEmpty()
                    || !(allTypesRequestSimpleListList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                xmlWriter.startElement("simpleList");

                for (String allTypesRequestSimpleListListValue : allTypesRequestSimpleListList) {
                    xmlWriter.startElement("member");
                    xmlWriter.value(allTypesRequestSimpleListListValue);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            java.util.List<SimpleStruct> allTypesRequestListOfStructsList = allTypesRequest.listOfStructs();
            if (!allTypesRequestListOfStructsList.isEmpty()
                    || !(allTypesRequestListOfStructsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                xmlWriter.startElement("listOfStructs");

                for (SimpleStruct allTypesRequestListOfStructsListValue : allTypesRequestListOfStructsList) {
                    xmlWriter.startElement("member");

                    if (allTypesRequestListOfStructsListValue.stringMember() != null) {
                        xmlWriter.startElement("StringMember").value(allTypesRequestListOfStructsListValue.stringMember())
                                .endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            java.util.Map<String, String> allTypesRequestMapOfStringToStringMap = (java.util.Map<String, String>) allTypesRequest
                    .mapOfStringToString();
            if (!allTypesRequestMapOfStringToStringMap.isEmpty()
                    || !(allTypesRequestMapOfStringToStringMap instanceof software.amazon.awssdk.core.util.SdkAutoConstructMap)) {
                xmlWriter.startElement("mapOfStringToString");

                for (Map.Entry<String, String> allTypesRequestMapOfStringToStringMapValue : allTypesRequestMapOfStringToStringMap
                        .entrySet()) {
                    xmlWriter.startElement("entry");
                    xmlWriter.startElement("key");
                    xmlWriter.value(allTypesRequestMapOfStringToStringMapValue.getKey());
                    xmlWriter.endElement();
                    xmlWriter.startElement("value");
                    xmlWriter.value(allTypesRequestMapOfStringToStringMapValue.getValue());
                    xmlWriter.endElement();
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (allTypesRequest.timestampMember() != null) {
                xmlWriter.startElement("timestampMember").value(allTypesRequest.timestampMember()).endElement();
            }

            StructWithTimestamp structWithNestedTimestampMember = allTypesRequest.structWithNestedTimestampMember();
            if (structWithNestedTimestampMember != null) {
                xmlWriter.startElement("structWithNestedTimestampMember");

                if (structWithNestedTimestampMember.nestedTimestamp() != null) {
                    xmlWriter.startElement("NestedTimestamp").value(structWithNestedTimestampMember.nestedTimestamp())
                            .endElement();
                }
                xmlWriter.endElement();
            }

            if (allTypesRequest.blobArg() != null) {
                xmlWriter.startElement("blobArg").value(allTypesRequest.blobArg().asByteBuffer()).endElement();
            }

            java.util.Map<String, software.amazon.awssdk.core.SdkBytes> allTypesRequestBlobMapMap = (java.util.Map<String, software.amazon.awssdk.core.SdkBytes>) allTypesRequest
                    .blobMap();
            if (!allTypesRequestBlobMapMap.isEmpty()
                    || !(allTypesRequestBlobMapMap instanceof software.amazon.awssdk.core.util.SdkAutoConstructMap)) {
                xmlWriter.startElement("blobMap");

                for (Map.Entry<String, software.amazon.awssdk.core.SdkBytes> allTypesRequestBlobMapMapValue : allTypesRequestBlobMapMap
                        .entrySet()) {
                    xmlWriter.startElement("entry");
                    xmlWriter.startElement("key");
                    xmlWriter.value(allTypesRequestBlobMapMapValue.getKey());
                    xmlWriter.endElement();
                    xmlWriter.startElement("value");
                    xmlWriter.value(allTypesRequestBlobMapMapValue.getValue().asByteBuffer());
                    xmlWriter.endElement();
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            java.util.List<software.amazon.awssdk.core.SdkBytes> allTypesRequestListOfBlobsList = allTypesRequest.listOfBlobs();
            if (!allTypesRequestListOfBlobsList.isEmpty()
                    || !(allTypesRequestListOfBlobsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                xmlWriter.startElement("listOfBlobs");

                for (software.amazon.awssdk.core.SdkBytes allTypesRequestListOfBlobsListValue : allTypesRequestListOfBlobsList) {
                    xmlWriter.startElement("member");
                    xmlWriter.value(allTypesRequestListOfBlobsListValue.asByteBuffer());
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}