/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IdempotentOperationRequest extends ProtocolRestJsonRequest implements
        ToCopyableBuilder<IdempotentOperationRequest.Builder, IdempotentOperationRequest> {
    private final String pathIdempotentToken;

    private final String queryIdempotentToken;

    private final String headerIdempotentToken;

    private IdempotentOperationRequest(BuilderImpl builder) {
        super(builder);
        this.pathIdempotentToken = builder.pathIdempotentToken;
        this.queryIdempotentToken = builder.queryIdempotentToken;
        this.headerIdempotentToken = builder.headerIdempotentToken;
    }

    /**
     * Returns the value of the PathIdempotentToken property for this object.
     * 
     * @return The value of the PathIdempotentToken property for this object.
     */
    public String pathIdempotentToken() {
        return pathIdempotentToken;
    }

    /**
     * Returns the value of the QueryIdempotentToken property for this object.
     * 
     * @return The value of the QueryIdempotentToken property for this object.
     */
    public String queryIdempotentToken() {
        return queryIdempotentToken;
    }

    /**
     * Returns the value of the HeaderIdempotentToken property for this object.
     * 
     * @return The value of the HeaderIdempotentToken property for this object.
     */
    public String headerIdempotentToken() {
        return headerIdempotentToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pathIdempotentToken());
        hashCode = 31 * hashCode + Objects.hashCode(queryIdempotentToken());
        hashCode = 31 * hashCode + Objects.hashCode(headerIdempotentToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdempotentOperationRequest)) {
            return false;
        }
        IdempotentOperationRequest other = (IdempotentOperationRequest) obj;
        return Objects.equals(pathIdempotentToken(), other.pathIdempotentToken())
                && Objects.equals(queryIdempotentToken(), other.queryIdempotentToken())
                && Objects.equals(headerIdempotentToken(), other.headerIdempotentToken());
    }

    @Override
    public String toString() {
        return ToString.builder("IdempotentOperationRequest").add("PathIdempotentToken", pathIdempotentToken())
                .add("QueryIdempotentToken", queryIdempotentToken()).add("HeaderIdempotentToken", headerIdempotentToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PathIdempotentToken":
            return Optional.of(clazz.cast(pathIdempotentToken()));
        case "QueryIdempotentToken":
            return Optional.of(clazz.cast(queryIdempotentToken()));
        case "HeaderIdempotentToken":
            return Optional.of(clazz.cast(headerIdempotentToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolRestJsonRequest.Builder, CopyableBuilder<Builder, IdempotentOperationRequest> {
        /**
         * Sets the value of the PathIdempotentToken property for this object.
         *
         * @param pathIdempotentToken
         *        The new value for the PathIdempotentToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathIdempotentToken(String pathIdempotentToken);

        /**
         * Sets the value of the QueryIdempotentToken property for this object.
         *
         * @param queryIdempotentToken
         *        The new value for the QueryIdempotentToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryIdempotentToken(String queryIdempotentToken);

        /**
         * Sets the value of the HeaderIdempotentToken property for this object.
         *
         * @param headerIdempotentToken
         *        The new value for the HeaderIdempotentToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerIdempotentToken(String headerIdempotentToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtocolRestJsonRequest.BuilderImpl implements Builder {
        private String pathIdempotentToken;

        private String queryIdempotentToken;

        private String headerIdempotentToken;

        private BuilderImpl() {
        }

        private BuilderImpl(IdempotentOperationRequest model) {
            super(model);
            pathIdempotentToken(model.pathIdempotentToken);
            queryIdempotentToken(model.queryIdempotentToken);
            headerIdempotentToken(model.headerIdempotentToken);
        }

        public final String getPathIdempotentToken() {
            return pathIdempotentToken;
        }

        @Override
        public final Builder pathIdempotentToken(String pathIdempotentToken) {
            this.pathIdempotentToken = pathIdempotentToken;
            return this;
        }

        public final void setPathIdempotentToken(String pathIdempotentToken) {
            this.pathIdempotentToken = pathIdempotentToken;
        }

        public final String getQueryIdempotentToken() {
            return queryIdempotentToken;
        }

        @Override
        public final Builder queryIdempotentToken(String queryIdempotentToken) {
            this.queryIdempotentToken = queryIdempotentToken;
            return this;
        }

        public final void setQueryIdempotentToken(String queryIdempotentToken) {
            this.queryIdempotentToken = queryIdempotentToken;
        }

        public final String getHeaderIdempotentToken() {
            return headerIdempotentToken;
        }

        @Override
        public final Builder headerIdempotentToken(String headerIdempotentToken) {
            this.headerIdempotentToken = headerIdempotentToken;
            return this;
        }

        public final void setHeaderIdempotentToken(String headerIdempotentToken) {
            this.headerIdempotentToken = headerIdempotentToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public IdempotentOperationRequest build() {
            return new IdempotentOperationRequest(this);
        }
    }
}
