/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.protocolec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * AllTypesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AllTypesResponseUnmarshaller implements Unmarshaller<AllTypesResponse, StaxUnmarshallerContext> {

    public AllTypesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        AllTypesResponse.Builder allTypesResponse = AllTypesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> simpleList = null;
        java.util.List<SimpleStruct> listOfStructs = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                allTypesResponse.simpleList(simpleList);
                allTypesResponse.listOfStructs(listOfStructs);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("stringMember", targetDepth)) {
                    allTypesResponse.stringMember(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("integerMember", targetDepth)) {
                    allTypesResponse.integerMember(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("booleanMember", targetDepth)) {
                    allTypesResponse.booleanMember(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("floatMember", targetDepth)) {
                    allTypesResponse.floatMember(FloatUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("doubleMember", targetDepth)) {
                    allTypesResponse.doubleMember(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("longMember", targetDepth)) {
                    allTypesResponse.longMember(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("simpleStructMember", targetDepth)) {
                    allTypesResponse.simpleStructMember(SimpleStructUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("simpleList", targetDepth)) {
                    simpleList = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("simpleList/member", targetDepth)) {
                    simpleList.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("listOfStructs", targetDepth)) {
                    listOfStructs = new ArrayList<SimpleStruct>();
                    continue;
                }

                if (context.testExpression("listOfStructs/member", targetDepth)) {
                    listOfStructs.add(SimpleStructUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("timestampMember", targetDepth)) {
                    allTypesResponse.timestampMember(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("structWithNestedTimestampMember", targetDepth)) {
                    allTypesResponse.structWithNestedTimestampMember(StructWithTimestampUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("blobArg", targetDepth)) {
                    allTypesResponse.blobArg(ByteBufferUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    allTypesResponse.simpleList(simpleList);
                    allTypesResponse.listOfStructs(listOfStructs);
                    break;
                }
            }
        }
        return allTypesResponse.build();
    }

    private static final AllTypesResponseUnmarshaller INSTANCE = new AllTypesResponseUnmarshaller();

    public static AllTypesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
