/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.protocolrestjson.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * MultiLocationOperationRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class MultiLocationOperationRequestModelMarshaller {

    private static final MarshallingInfo<String> PATHPARAM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("PathParam").build();
    private static final MarshallingInfo<String> QUERYPARAMONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("QueryParamOne").build();
    private static final MarshallingInfo<String> QUERYPARAMTWO_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("QueryParamTwo").build();
    private static final MarshallingInfo<String> STRINGHEADERMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-header-string").build();
    private static final MarshallingInfo<java.util.Date> TIMESTAMPHEADERMEMBER_BINDING = MarshallingInfo
            .builder(MarshallingType.DATE).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-timearg")
            .build();
    private static final MarshallingInfo<StructuredPojo> PAYLOADSTRUCTPARAM_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("PayloadStructParam").build();

    private static final MultiLocationOperationRequestModelMarshaller instance = new MultiLocationOperationRequestModelMarshaller();

    public static MultiLocationOperationRequestModelMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(MultiLocationOperationRequest multiLocationOperationRequest, ProtocolMarshaller protocolMarshaller) {

        if (multiLocationOperationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(multiLocationOperationRequest.pathParam(), PATHPARAM_BINDING);
            protocolMarshaller.marshall(multiLocationOperationRequest.queryParamOne(), QUERYPARAMONE_BINDING);
            protocolMarshaller.marshall(multiLocationOperationRequest.queryParamTwo(), QUERYPARAMTWO_BINDING);
            protocolMarshaller.marshall(multiLocationOperationRequest.stringHeaderMember(), STRINGHEADERMEMBER_BINDING);
            protocolMarshaller.marshall(multiLocationOperationRequest.timestampHeaderMember(), TIMESTAMPHEADERMEMBER_BINDING);
            protocolMarshaller.marshall(multiLocationOperationRequest.payloadStructParam(), PAYLOADSTRUCTPARAM_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
