/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Ec2TypesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<Ec2TypesRequest.Builder, Ec2TypesRequest> {
    private final List<String> flattenedListOfStrings;

    private final List<SimpleStruct> flattenedListOfStructs;

    private final List<String> flattenedListWithLocation;

    private final String stringMemberWithLocation;

    private final String stringMemberWithQueryName;

    private final String stringMemberWithLocationAndQueryName;

    private final List<String> listMemberWithLocationAndQueryName;

    private final List<String> listMemberWithOnlyMemberLocation;

    private Ec2TypesRequest(BuilderImpl builder) {
        this.flattenedListOfStrings = builder.flattenedListOfStrings;
        this.flattenedListOfStructs = builder.flattenedListOfStructs;
        this.flattenedListWithLocation = builder.flattenedListWithLocation;
        this.stringMemberWithLocation = builder.stringMemberWithLocation;
        this.stringMemberWithQueryName = builder.stringMemberWithQueryName;
        this.stringMemberWithLocationAndQueryName = builder.stringMemberWithLocationAndQueryName;
        this.listMemberWithLocationAndQueryName = builder.listMemberWithLocationAndQueryName;
        this.listMemberWithOnlyMemberLocation = builder.listMemberWithOnlyMemberLocation;
    }

    /**
     *
     * @return
     */
    public List<String> flattenedListOfStrings() {
        return flattenedListOfStrings;
    }

    /**
     *
     * @return
     */
    public List<SimpleStruct> flattenedListOfStructs() {
        return flattenedListOfStructs;
    }

    /**
     *
     * @return
     */
    public List<String> flattenedListWithLocation() {
        return flattenedListWithLocation;
    }

    /**
     *
     * @return
     */
    public String stringMemberWithLocation() {
        return stringMemberWithLocation;
    }

    /**
     *
     * @return
     */
    public String stringMemberWithQueryName() {
        return stringMemberWithQueryName;
    }

    /**
     *
     * @return
     */
    public String stringMemberWithLocationAndQueryName() {
        return stringMemberWithLocationAndQueryName;
    }

    /**
     *
     * @return
     */
    public List<String> listMemberWithLocationAndQueryName() {
        return listMemberWithLocationAndQueryName;
    }

    /**
     *
     * @return
     */
    public List<String> listMemberWithOnlyMemberLocation() {
        return listMemberWithOnlyMemberLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((flattenedListOfStrings() == null) ? 0 : flattenedListOfStrings().hashCode());
        hashCode = 31 * hashCode + ((flattenedListOfStructs() == null) ? 0 : flattenedListOfStructs().hashCode());
        hashCode = 31 * hashCode + ((flattenedListWithLocation() == null) ? 0 : flattenedListWithLocation().hashCode());
        hashCode = 31 * hashCode + ((stringMemberWithLocation() == null) ? 0 : stringMemberWithLocation().hashCode());
        hashCode = 31 * hashCode + ((stringMemberWithQueryName() == null) ? 0 : stringMemberWithQueryName().hashCode());
        hashCode = 31 * hashCode
                + ((stringMemberWithLocationAndQueryName() == null) ? 0 : stringMemberWithLocationAndQueryName().hashCode());
        hashCode = 31 * hashCode
                + ((listMemberWithLocationAndQueryName() == null) ? 0 : listMemberWithLocationAndQueryName().hashCode());
        hashCode = 31 * hashCode
                + ((listMemberWithOnlyMemberLocation() == null) ? 0 : listMemberWithOnlyMemberLocation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2TypesRequest)) {
            return false;
        }
        Ec2TypesRequest other = (Ec2TypesRequest) obj;
        if (other.flattenedListOfStrings() == null ^ this.flattenedListOfStrings() == null) {
            return false;
        }
        if (other.flattenedListOfStrings() != null && !other.flattenedListOfStrings().equals(this.flattenedListOfStrings())) {
            return false;
        }
        if (other.flattenedListOfStructs() == null ^ this.flattenedListOfStructs() == null) {
            return false;
        }
        if (other.flattenedListOfStructs() != null && !other.flattenedListOfStructs().equals(this.flattenedListOfStructs())) {
            return false;
        }
        if (other.flattenedListWithLocation() == null ^ this.flattenedListWithLocation() == null) {
            return false;
        }
        if (other.flattenedListWithLocation() != null
                && !other.flattenedListWithLocation().equals(this.flattenedListWithLocation())) {
            return false;
        }
        if (other.stringMemberWithLocation() == null ^ this.stringMemberWithLocation() == null) {
            return false;
        }
        if (other.stringMemberWithLocation() != null && !other.stringMemberWithLocation().equals(this.stringMemberWithLocation())) {
            return false;
        }
        if (other.stringMemberWithQueryName() == null ^ this.stringMemberWithQueryName() == null) {
            return false;
        }
        if (other.stringMemberWithQueryName() != null
                && !other.stringMemberWithQueryName().equals(this.stringMemberWithQueryName())) {
            return false;
        }
        if (other.stringMemberWithLocationAndQueryName() == null ^ this.stringMemberWithLocationAndQueryName() == null) {
            return false;
        }
        if (other.stringMemberWithLocationAndQueryName() != null
                && !other.stringMemberWithLocationAndQueryName().equals(this.stringMemberWithLocationAndQueryName())) {
            return false;
        }
        if (other.listMemberWithLocationAndQueryName() == null ^ this.listMemberWithLocationAndQueryName() == null) {
            return false;
        }
        if (other.listMemberWithLocationAndQueryName() != null
                && !other.listMemberWithLocationAndQueryName().equals(this.listMemberWithLocationAndQueryName())) {
            return false;
        }
        if (other.listMemberWithOnlyMemberLocation() == null ^ this.listMemberWithOnlyMemberLocation() == null) {
            return false;
        }
        if (other.listMemberWithOnlyMemberLocation() != null
                && !other.listMemberWithOnlyMemberLocation().equals(this.listMemberWithOnlyMemberLocation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (flattenedListOfStrings() != null) {
            sb.append("FlattenedListOfStrings: ").append(flattenedListOfStrings()).append(",");
        }
        if (flattenedListOfStructs() != null) {
            sb.append("FlattenedListOfStructs: ").append(flattenedListOfStructs()).append(",");
        }
        if (flattenedListWithLocation() != null) {
            sb.append("FlattenedListWithLocation: ").append(flattenedListWithLocation()).append(",");
        }
        if (stringMemberWithLocation() != null) {
            sb.append("StringMemberWithLocation: ").append(stringMemberWithLocation()).append(",");
        }
        if (stringMemberWithQueryName() != null) {
            sb.append("StringMemberWithQueryName: ").append(stringMemberWithQueryName()).append(",");
        }
        if (stringMemberWithLocationAndQueryName() != null) {
            sb.append("StringMemberWithLocationAndQueryName: ").append(stringMemberWithLocationAndQueryName()).append(",");
        }
        if (listMemberWithLocationAndQueryName() != null) {
            sb.append("ListMemberWithLocationAndQueryName: ").append(listMemberWithLocationAndQueryName()).append(",");
        }
        if (listMemberWithOnlyMemberLocation() != null) {
            sb.append("ListMemberWithOnlyMemberLocation: ").append(listMemberWithOnlyMemberLocation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Ec2TypesRequest> {
        /**
         *
         * @param flattenedListOfStrings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFlattenedListOfStrings(java.util.Collection)} or
         * {@link #withFlattenedListOfStrings(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param flattenedListOfStrings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(String... flattenedListOfStrings);

        /**
         *
         * @param flattenedListOfStructs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFlattenedListOfStructs(java.util.Collection)} or
         * {@link #withFlattenedListOfStructs(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param flattenedListOfStructs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs);

        /**
         *
         * @param flattenedListWithLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFlattenedListWithLocation(java.util.Collection)} or
         * {@link #withFlattenedListWithLocation(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param flattenedListWithLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(String... flattenedListWithLocation);

        /**
         *
         * @param stringMemberWithLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberWithLocation(String stringMemberWithLocation);

        /**
         *
         * @param stringMemberWithQueryName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberWithQueryName(String stringMemberWithQueryName);

        /**
         *
         * @param stringMemberWithLocationAndQueryName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberWithLocationAndQueryName(String stringMemberWithLocationAndQueryName);

        /**
         *
         * @param listMemberWithLocationAndQueryName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithLocationAndQueryName(Collection<String> listMemberWithLocationAndQueryName);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setListMemberWithLocationAndQueryName(java.util.Collection)} or
         * {@link #withListMemberWithLocationAndQueryName(java.util.Collection)} if you want to override the existing
         * values.
         * </p>
         * 
         * @param listMemberWithLocationAndQueryName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithLocationAndQueryName(String... listMemberWithLocationAndQueryName);

        /**
         *
         * @param listMemberWithOnlyMemberLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithOnlyMemberLocation(Collection<String> listMemberWithOnlyMemberLocation);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setListMemberWithOnlyMemberLocation(java.util.Collection)} or
         * {@link #withListMemberWithOnlyMemberLocation(java.util.Collection)} if you want to override the existing
         * values.
         * </p>
         * 
         * @param listMemberWithOnlyMemberLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithOnlyMemberLocation(String... listMemberWithOnlyMemberLocation);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> flattenedListOfStrings;

        private List<SimpleStruct> flattenedListOfStructs;

        private List<String> flattenedListWithLocation;

        private String stringMemberWithLocation;

        private String stringMemberWithQueryName;

        private String stringMemberWithLocationAndQueryName;

        private List<String> listMemberWithLocationAndQueryName;

        private List<String> listMemberWithOnlyMemberLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2TypesRequest model) {
            setFlattenedListOfStrings(model.flattenedListOfStrings);
            setFlattenedListOfStructs(model.flattenedListOfStructs);
            setFlattenedListWithLocation(model.flattenedListWithLocation);
            setStringMemberWithLocation(model.stringMemberWithLocation);
            setStringMemberWithQueryName(model.stringMemberWithQueryName);
            setStringMemberWithLocationAndQueryName(model.stringMemberWithLocationAndQueryName);
            setListMemberWithLocationAndQueryName(model.listMemberWithLocationAndQueryName);
            setListMemberWithOnlyMemberLocation(model.listMemberWithOnlyMemberLocation);
        }

        public final Collection<String> getFlattenedListOfStrings() {
            return flattenedListOfStrings;
        }

        @Override
        public final Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStrings(String... flattenedListOfStrings) {
            if (this.flattenedListOfStrings == null) {
                this.flattenedListOfStrings = new ArrayList<>(flattenedListOfStrings.length);
            }
            for (String e : flattenedListOfStrings) {
                this.flattenedListOfStrings.add(e);
            }
            return this;
        }

        public final void setFlattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
        }

        @SafeVarargs
        public final void setFlattenedListOfStrings(String... flattenedListOfStrings) {
            if (this.flattenedListOfStrings == null) {
                this.flattenedListOfStrings = new ArrayList<>(flattenedListOfStrings.length);
            }
            for (String e : flattenedListOfStrings) {
                this.flattenedListOfStrings.add(e);
            }
        }

        public final Collection<SimpleStruct> getFlattenedListOfStructs() {
            return flattenedListOfStructs;
        }

        @Override
        public final Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            if (this.flattenedListOfStructs == null) {
                this.flattenedListOfStructs = new ArrayList<>(flattenedListOfStructs.length);
            }
            for (SimpleStruct e : flattenedListOfStructs) {
                this.flattenedListOfStructs.add(e);
            }
            return this;
        }

        public final void setFlattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
        }

        @SafeVarargs
        public final void setFlattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            if (this.flattenedListOfStructs == null) {
                this.flattenedListOfStructs = new ArrayList<>(flattenedListOfStructs.length);
            }
            for (SimpleStruct e : flattenedListOfStructs) {
                this.flattenedListOfStructs.add(e);
            }
        }

        public final Collection<String> getFlattenedListWithLocation() {
            return flattenedListWithLocation;
        }

        @Override
        public final Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListWithLocation(String... flattenedListWithLocation) {
            if (this.flattenedListWithLocation == null) {
                this.flattenedListWithLocation = new ArrayList<>(flattenedListWithLocation.length);
            }
            for (String e : flattenedListWithLocation) {
                this.flattenedListWithLocation.add(e);
            }
            return this;
        }

        public final void setFlattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
        }

        @SafeVarargs
        public final void setFlattenedListWithLocation(String... flattenedListWithLocation) {
            if (this.flattenedListWithLocation == null) {
                this.flattenedListWithLocation = new ArrayList<>(flattenedListWithLocation.length);
            }
            for (String e : flattenedListWithLocation) {
                this.flattenedListWithLocation.add(e);
            }
        }

        public final String getStringMemberWithLocation() {
            return stringMemberWithLocation;
        }

        @Override
        public final Builder stringMemberWithLocation(String stringMemberWithLocation) {
            this.stringMemberWithLocation = stringMemberWithLocation;
            return this;
        }

        public final void setStringMemberWithLocation(String stringMemberWithLocation) {
            this.stringMemberWithLocation = stringMemberWithLocation;
        }

        public final String getStringMemberWithQueryName() {
            return stringMemberWithQueryName;
        }

        @Override
        public final Builder stringMemberWithQueryName(String stringMemberWithQueryName) {
            this.stringMemberWithQueryName = stringMemberWithQueryName;
            return this;
        }

        public final void setStringMemberWithQueryName(String stringMemberWithQueryName) {
            this.stringMemberWithQueryName = stringMemberWithQueryName;
        }

        public final String getStringMemberWithLocationAndQueryName() {
            return stringMemberWithLocationAndQueryName;
        }

        @Override
        public final Builder stringMemberWithLocationAndQueryName(String stringMemberWithLocationAndQueryName) {
            this.stringMemberWithLocationAndQueryName = stringMemberWithLocationAndQueryName;
            return this;
        }

        public final void setStringMemberWithLocationAndQueryName(String stringMemberWithLocationAndQueryName) {
            this.stringMemberWithLocationAndQueryName = stringMemberWithLocationAndQueryName;
        }

        public final Collection<String> getListMemberWithLocationAndQueryName() {
            return listMemberWithLocationAndQueryName;
        }

        @Override
        public final Builder listMemberWithLocationAndQueryName(Collection<String> listMemberWithLocationAndQueryName) {
            this.listMemberWithLocationAndQueryName = ListOfStringsCopier.copy(listMemberWithLocationAndQueryName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listMemberWithLocationAndQueryName(String... listMemberWithLocationAndQueryName) {
            if (this.listMemberWithLocationAndQueryName == null) {
                this.listMemberWithLocationAndQueryName = new ArrayList<>(listMemberWithLocationAndQueryName.length);
            }
            for (String e : listMemberWithLocationAndQueryName) {
                this.listMemberWithLocationAndQueryName.add(e);
            }
            return this;
        }

        public final void setListMemberWithLocationAndQueryName(Collection<String> listMemberWithLocationAndQueryName) {
            this.listMemberWithLocationAndQueryName = ListOfStringsCopier.copy(listMemberWithLocationAndQueryName);
        }

        @SafeVarargs
        public final void setListMemberWithLocationAndQueryName(String... listMemberWithLocationAndQueryName) {
            if (this.listMemberWithLocationAndQueryName == null) {
                this.listMemberWithLocationAndQueryName = new ArrayList<>(listMemberWithLocationAndQueryName.length);
            }
            for (String e : listMemberWithLocationAndQueryName) {
                this.listMemberWithLocationAndQueryName.add(e);
            }
        }

        public final Collection<String> getListMemberWithOnlyMemberLocation() {
            return listMemberWithOnlyMemberLocation;
        }

        @Override
        public final Builder listMemberWithOnlyMemberLocation(Collection<String> listMemberWithOnlyMemberLocation) {
            this.listMemberWithOnlyMemberLocation = ListOfStringsCopier.copy(listMemberWithOnlyMemberLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listMemberWithOnlyMemberLocation(String... listMemberWithOnlyMemberLocation) {
            if (this.listMemberWithOnlyMemberLocation == null) {
                this.listMemberWithOnlyMemberLocation = new ArrayList<>(listMemberWithOnlyMemberLocation.length);
            }
            for (String e : listMemberWithOnlyMemberLocation) {
                this.listMemberWithOnlyMemberLocation.add(e);
            }
            return this;
        }

        public final void setListMemberWithOnlyMemberLocation(Collection<String> listMemberWithOnlyMemberLocation) {
            this.listMemberWithOnlyMemberLocation = ListOfStringsCopier.copy(listMemberWithOnlyMemberLocation);
        }

        @SafeVarargs
        public final void setListMemberWithOnlyMemberLocation(String... listMemberWithOnlyMemberLocation) {
            if (this.listMemberWithOnlyMemberLocation == null) {
                this.listMemberWithOnlyMemberLocation = new ArrayList<>(listMemberWithOnlyMemberLocation.length);
            }
            for (String e : listMemberWithOnlyMemberLocation) {
                this.listMemberWithOnlyMemberLocation.add(e);
            }
        }

        @Override
        public Ec2TypesRequest build() {
            return new Ec2TypesRequest(this);
        }
    }
}
