/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.RecursiveStructureMarshaller;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RecursiveStructure implements StructuredPojo, ToCopyableBuilder<RecursiveStructure.Builder, RecursiveStructure> {
    private final RecursiveStructure recursiveMember;

    private final String noRecurseMember;

    private RecursiveStructure(BuilderImpl builder) {
        this.recursiveMember = builder.recursiveMember;
        this.noRecurseMember = builder.noRecurseMember;
    }

    /**
     *
     * @return
     */
    public RecursiveStructure recursiveMember() {
        return recursiveMember;
    }

    /**
     *
     * @return
     */
    public String noRecurseMember() {
        return noRecurseMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((recursiveMember() == null) ? 0 : recursiveMember().hashCode());
        hashCode = 31 * hashCode + ((noRecurseMember() == null) ? 0 : noRecurseMember().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecursiveStructure)) {
            return false;
        }
        RecursiveStructure other = (RecursiveStructure) obj;
        if (other.recursiveMember() == null ^ this.recursiveMember() == null) {
            return false;
        }
        if (other.recursiveMember() != null && !other.recursiveMember().equals(this.recursiveMember())) {
            return false;
        }
        if (other.noRecurseMember() == null ^ this.noRecurseMember() == null) {
            return false;
        }
        if (other.noRecurseMember() != null && !other.noRecurseMember().equals(this.noRecurseMember())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (recursiveMember() != null) {
            sb.append("RecursiveMember: ").append(recursiveMember()).append(",");
        }
        if (noRecurseMember() != null) {
            sb.append("NoRecurseMember: ").append(noRecurseMember()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecursiveStructureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RecursiveStructure> {
        /**
         *
         * @param recursiveMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursiveMember(RecursiveStructure recursiveMember);

        /**
         *
         * @param noRecurseMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noRecurseMember(String noRecurseMember);
    }

    private static final class BuilderImpl implements Builder {
        private RecursiveStructure recursiveMember;

        private String noRecurseMember;

        private BuilderImpl() {
        }

        private BuilderImpl(RecursiveStructure model) {
            setRecursiveMember(model.recursiveMember);
            setNoRecurseMember(model.noRecurseMember);
        }

        public final RecursiveStructure getRecursiveMember() {
            return recursiveMember;
        }

        @Override
        public final Builder recursiveMember(RecursiveStructure recursiveMember) {
            this.recursiveMember = recursiveMember;
            return this;
        }

        public final void setRecursiveMember(RecursiveStructure recursiveMember) {
            this.recursiveMember = recursiveMember;
        }

        public final String getNoRecurseMember() {
            return noRecurseMember;
        }

        @Override
        public final Builder noRecurseMember(String noRecurseMember) {
            this.noRecurseMember = noRecurseMember;
            return this;
        }

        public final void setNoRecurseMember(String noRecurseMember) {
            this.noRecurseMember = noRecurseMember;
        }

        @Override
        public RecursiveStructure build() {
            return new RecursiveStructure(this);
        }
    }
}
