/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model;

import javax.annotation.Generated;
import software.amazon.awssdk.opensdk.BaseResult;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MultiLocationOperationResponse extends BaseResult implements
        ToCopyableBuilder<MultiLocationOperationResponse.Builder, MultiLocationOperationResponse> {
    private final AllTypesStructure payloadMember;

    private final String headerMember;

    private final String queryMemberOne;

    private final String queryMemberTwo;

    private final String pathMember;

    private MultiLocationOperationResponse(BuilderImpl builder) {
        this.payloadMember = builder.payloadMember;
        this.headerMember = builder.headerMember;
        this.queryMemberOne = builder.queryMemberOne;
        this.queryMemberTwo = builder.queryMemberTwo;
        this.pathMember = builder.pathMember;
    }

    /**
     *
     * @return
     */
    public AllTypesStructure payloadMember() {
        return payloadMember;
    }

    /**
     *
     * @return
     */
    public String headerMember() {
        return headerMember;
    }

    /**
     *
     * @return
     */
    public String queryMemberOne() {
        return queryMemberOne;
    }

    /**
     *
     * @return
     */
    public String queryMemberTwo() {
        return queryMemberTwo;
    }

    /**
     *
     * @return
     */
    public String pathMember() {
        return pathMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((payloadMember() == null) ? 0 : payloadMember().hashCode());
        hashCode = 31 * hashCode + ((headerMember() == null) ? 0 : headerMember().hashCode());
        hashCode = 31 * hashCode + ((queryMemberOne() == null) ? 0 : queryMemberOne().hashCode());
        hashCode = 31 * hashCode + ((queryMemberTwo() == null) ? 0 : queryMemberTwo().hashCode());
        hashCode = 31 * hashCode + ((pathMember() == null) ? 0 : pathMember().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiLocationOperationResponse)) {
            return false;
        }
        MultiLocationOperationResponse other = (MultiLocationOperationResponse) obj;
        if (other.payloadMember() == null ^ this.payloadMember() == null) {
            return false;
        }
        if (other.payloadMember() != null && !other.payloadMember().equals(this.payloadMember())) {
            return false;
        }
        if (other.headerMember() == null ^ this.headerMember() == null) {
            return false;
        }
        if (other.headerMember() != null && !other.headerMember().equals(this.headerMember())) {
            return false;
        }
        if (other.queryMemberOne() == null ^ this.queryMemberOne() == null) {
            return false;
        }
        if (other.queryMemberOne() != null && !other.queryMemberOne().equals(this.queryMemberOne())) {
            return false;
        }
        if (other.queryMemberTwo() == null ^ this.queryMemberTwo() == null) {
            return false;
        }
        if (other.queryMemberTwo() != null && !other.queryMemberTwo().equals(this.queryMemberTwo())) {
            return false;
        }
        if (other.pathMember() == null ^ this.pathMember() == null) {
            return false;
        }
        if (other.pathMember() != null && !other.pathMember().equals(this.pathMember())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (payloadMember() != null) {
            sb.append("PayloadMember: ").append(payloadMember()).append(",");
        }
        if (headerMember() != null) {
            sb.append("HeaderMember: ").append(headerMember()).append(",");
        }
        if (queryMemberOne() != null) {
            sb.append("QueryMemberOne: ").append(queryMemberOne()).append(",");
        }
        if (queryMemberTwo() != null) {
            sb.append("QueryMemberTwo: ").append(queryMemberTwo()).append(",");
        }
        if (pathMember() != null) {
            sb.append("PathMember: ").append(pathMember()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MultiLocationOperationResponse> {
        /**
         *
         * @param payloadMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMember(AllTypesStructure payloadMember);

        /**
         *
         * @param headerMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerMember(String headerMember);

        /**
         *
         * @param queryMemberOne
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryMemberOne(String queryMemberOne);

        /**
         *
         * @param queryMemberTwo
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryMemberTwo(String queryMemberTwo);

        /**
         *
         * @param pathMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathMember(String pathMember);
    }

    private static final class BuilderImpl implements Builder {
        private AllTypesStructure payloadMember;

        private String headerMember;

        private String queryMemberOne;

        private String queryMemberTwo;

        private String pathMember;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiLocationOperationResponse model) {
            setPayloadMember(model.payloadMember);
            setHeaderMember(model.headerMember);
            setQueryMemberOne(model.queryMemberOne);
            setQueryMemberTwo(model.queryMemberTwo);
            setPathMember(model.pathMember);
        }

        public final AllTypesStructure getPayloadMember() {
            return payloadMember;
        }

        @Override
        public final Builder payloadMember(AllTypesStructure payloadMember) {
            this.payloadMember = payloadMember;
            return this;
        }

        public final void setPayloadMember(AllTypesStructure payloadMember) {
            this.payloadMember = payloadMember;
        }

        public final String getHeaderMember() {
            return headerMember;
        }

        @Override
        public final Builder headerMember(String headerMember) {
            this.headerMember = headerMember;
            return this;
        }

        public final void setHeaderMember(String headerMember) {
            this.headerMember = headerMember;
        }

        public final String getQueryMemberOne() {
            return queryMemberOne;
        }

        @Override
        public final Builder queryMemberOne(String queryMemberOne) {
            this.queryMemberOne = queryMemberOne;
            return this;
        }

        public final void setQueryMemberOne(String queryMemberOne) {
            this.queryMemberOne = queryMemberOne;
        }

        public final String getQueryMemberTwo() {
            return queryMemberTwo;
        }

        @Override
        public final Builder queryMemberTwo(String queryMemberTwo) {
            this.queryMemberTwo = queryMemberTwo;
            return this;
        }

        public final void setQueryMemberTwo(String queryMemberTwo) {
            this.queryMemberTwo = queryMemberTwo;
        }

        public final String getPathMember() {
            return pathMember;
        }

        @Override
        public final Builder pathMember(String pathMember) {
            this.pathMember = pathMember;
            return this;
        }

        public final void setPathMember(String pathMember) {
            this.pathMember = pathMember;
        }

        @Override
        public MultiLocationOperationResponse build() {
            return new MultiLocationOperationResponse(this);
        }
    }
}
