/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform.AllTypesStructureMarshaller;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AllTypesStructure implements StructuredPojo, ToCopyableBuilder<AllTypesStructure.Builder, AllTypesStructure> {
    private final String stringMember;

    private final Integer integerMember;

    private final Double numberMember;

    private final Boolean booleanMember;

    private final StructureWithStringMember nestedStructure;

    private final RecursiveStructure recursiveStructure;

    private final List<String> listOfStrings;

    private final List<StructureWithStringMember> listOfStructs;

    private AllTypesStructure(BuilderImpl builder) {
        this.stringMember = builder.stringMember;
        this.integerMember = builder.integerMember;
        this.numberMember = builder.numberMember;
        this.booleanMember = builder.booleanMember;
        this.nestedStructure = builder.nestedStructure;
        this.recursiveStructure = builder.recursiveStructure;
        this.listOfStrings = builder.listOfStrings;
        this.listOfStructs = builder.listOfStructs;
    }

    /**
     *
     * @return
     */
    public String stringMember() {
        return stringMember;
    }

    /**
     *
     * @return
     */
    public Integer integerMember() {
        return integerMember;
    }

    /**
     *
     * @return
     */
    public Double numberMember() {
        return numberMember;
    }

    /**
     *
     * @return
     */
    public Boolean booleanMember() {
        return booleanMember;
    }

    /**
     *
     * @return
     */
    public StructureWithStringMember nestedStructure() {
        return nestedStructure;
    }

    /**
     *
     * @return
     */
    public RecursiveStructure recursiveStructure() {
        return recursiveStructure;
    }

    /**
     *
     * @return
     */
    public List<String> listOfStrings() {
        return listOfStrings;
    }

    /**
     *
     * @return
     */
    public List<StructureWithStringMember> listOfStructs() {
        return listOfStructs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stringMember() == null) ? 0 : stringMember().hashCode());
        hashCode = 31 * hashCode + ((integerMember() == null) ? 0 : integerMember().hashCode());
        hashCode = 31 * hashCode + ((numberMember() == null) ? 0 : numberMember().hashCode());
        hashCode = 31 * hashCode + ((booleanMember() == null) ? 0 : booleanMember().hashCode());
        hashCode = 31 * hashCode + ((nestedStructure() == null) ? 0 : nestedStructure().hashCode());
        hashCode = 31 * hashCode + ((recursiveStructure() == null) ? 0 : recursiveStructure().hashCode());
        hashCode = 31 * hashCode + ((listOfStrings() == null) ? 0 : listOfStrings().hashCode());
        hashCode = 31 * hashCode + ((listOfStructs() == null) ? 0 : listOfStructs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllTypesStructure)) {
            return false;
        }
        AllTypesStructure other = (AllTypesStructure) obj;
        if (other.stringMember() == null ^ this.stringMember() == null) {
            return false;
        }
        if (other.stringMember() != null && !other.stringMember().equals(this.stringMember())) {
            return false;
        }
        if (other.integerMember() == null ^ this.integerMember() == null) {
            return false;
        }
        if (other.integerMember() != null && !other.integerMember().equals(this.integerMember())) {
            return false;
        }
        if (other.numberMember() == null ^ this.numberMember() == null) {
            return false;
        }
        if (other.numberMember() != null && !other.numberMember().equals(this.numberMember())) {
            return false;
        }
        if (other.booleanMember() == null ^ this.booleanMember() == null) {
            return false;
        }
        if (other.booleanMember() != null && !other.booleanMember().equals(this.booleanMember())) {
            return false;
        }
        if (other.nestedStructure() == null ^ this.nestedStructure() == null) {
            return false;
        }
        if (other.nestedStructure() != null && !other.nestedStructure().equals(this.nestedStructure())) {
            return false;
        }
        if (other.recursiveStructure() == null ^ this.recursiveStructure() == null) {
            return false;
        }
        if (other.recursiveStructure() != null && !other.recursiveStructure().equals(this.recursiveStructure())) {
            return false;
        }
        if (other.listOfStrings() == null ^ this.listOfStrings() == null) {
            return false;
        }
        if (other.listOfStrings() != null && !other.listOfStrings().equals(this.listOfStrings())) {
            return false;
        }
        if (other.listOfStructs() == null ^ this.listOfStructs() == null) {
            return false;
        }
        if (other.listOfStructs() != null && !other.listOfStructs().equals(this.listOfStructs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stringMember() != null) {
            sb.append("StringMember: ").append(stringMember()).append(",");
        }
        if (integerMember() != null) {
            sb.append("IntegerMember: ").append(integerMember()).append(",");
        }
        if (numberMember() != null) {
            sb.append("NumberMember: ").append(numberMember()).append(",");
        }
        if (booleanMember() != null) {
            sb.append("BooleanMember: ").append(booleanMember()).append(",");
        }
        if (nestedStructure() != null) {
            sb.append("NestedStructure: ").append(nestedStructure()).append(",");
        }
        if (recursiveStructure() != null) {
            sb.append("RecursiveStructure: ").append(recursiveStructure()).append(",");
        }
        if (listOfStrings() != null) {
            sb.append("ListOfStrings: ").append(listOfStrings()).append(",");
        }
        if (listOfStructs() != null) {
            sb.append("ListOfStructs: ").append(listOfStructs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AllTypesStructureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AllTypesStructure> {
        /**
         *
         * @param stringMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMember(String stringMember);

        /**
         *
         * @param integerMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerMember(Integer integerMember);

        /**
         *
         * @param numberMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberMember(Double numberMember);

        /**
         *
         * @param booleanMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanMember(Boolean booleanMember);

        /**
         *
         * @param nestedStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedStructure(StructureWithStringMember nestedStructure);

        /**
         *
         * @param recursiveStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursiveStructure(RecursiveStructure recursiveStructure);

        /**
         *
         * @param listOfStrings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStrings(Collection<String> listOfStrings);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setListOfStrings(java.util.Collection)} or {@link #withListOfStrings(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param listOfStrings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStrings(String... listOfStrings);

        /**
         *
         * @param listOfStructs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStructs(Collection<StructureWithStringMember> listOfStructs);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setListOfStructs(java.util.Collection)} or {@link #withListOfStructs(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param listOfStructs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStructs(StructureWithStringMember... listOfStructs);
    }

    private static final class BuilderImpl implements Builder {
        private String stringMember;

        private Integer integerMember;

        private Double numberMember;

        private Boolean booleanMember;

        private StructureWithStringMember nestedStructure;

        private RecursiveStructure recursiveStructure;

        private List<String> listOfStrings;

        private List<StructureWithStringMember> listOfStructs;

        private BuilderImpl() {
        }

        private BuilderImpl(AllTypesStructure model) {
            setStringMember(model.stringMember);
            setIntegerMember(model.integerMember);
            setNumberMember(model.numberMember);
            setBooleanMember(model.booleanMember);
            setNestedStructure(model.nestedStructure);
            setRecursiveStructure(model.recursiveStructure);
            setListOfStrings(model.listOfStrings);
            setListOfStructs(model.listOfStructs);
        }

        public final String getStringMember() {
            return stringMember;
        }

        @Override
        public final Builder stringMember(String stringMember) {
            this.stringMember = stringMember;
            return this;
        }

        public final void setStringMember(String stringMember) {
            this.stringMember = stringMember;
        }

        public final Integer getIntegerMember() {
            return integerMember;
        }

        @Override
        public final Builder integerMember(Integer integerMember) {
            this.integerMember = integerMember;
            return this;
        }

        public final void setIntegerMember(Integer integerMember) {
            this.integerMember = integerMember;
        }

        public final Double getNumberMember() {
            return numberMember;
        }

        @Override
        public final Builder numberMember(Double numberMember) {
            this.numberMember = numberMember;
            return this;
        }

        public final void setNumberMember(Double numberMember) {
            this.numberMember = numberMember;
        }

        public final Boolean getBooleanMember() {
            return booleanMember;
        }

        @Override
        public final Builder booleanMember(Boolean booleanMember) {
            this.booleanMember = booleanMember;
            return this;
        }

        public final void setBooleanMember(Boolean booleanMember) {
            this.booleanMember = booleanMember;
        }

        public final StructureWithStringMember getNestedStructure() {
            return nestedStructure;
        }

        @Override
        public final Builder nestedStructure(StructureWithStringMember nestedStructure) {
            this.nestedStructure = nestedStructure;
            return this;
        }

        public final void setNestedStructure(StructureWithStringMember nestedStructure) {
            this.nestedStructure = nestedStructure;
        }

        public final RecursiveStructure getRecursiveStructure() {
            return recursiveStructure;
        }

        @Override
        public final Builder recursiveStructure(RecursiveStructure recursiveStructure) {
            this.recursiveStructure = recursiveStructure;
            return this;
        }

        public final void setRecursiveStructure(RecursiveStructure recursiveStructure) {
            this.recursiveStructure = recursiveStructure;
        }

        public final Collection<String> getListOfStrings() {
            return listOfStrings;
        }

        @Override
        public final Builder listOfStrings(Collection<String> listOfStrings) {
            this.listOfStrings = ListOfStringsCopier.copy(listOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfStrings(String... listOfStrings) {
            if (this.listOfStrings == null) {
                this.listOfStrings = new ArrayList<>(listOfStrings.length);
            }
            for (String e : listOfStrings) {
                this.listOfStrings.add(e);
            }
            return this;
        }

        public final void setListOfStrings(Collection<String> listOfStrings) {
            this.listOfStrings = ListOfStringsCopier.copy(listOfStrings);
        }

        @SafeVarargs
        public final void setListOfStrings(String... listOfStrings) {
            if (this.listOfStrings == null) {
                this.listOfStrings = new ArrayList<>(listOfStrings.length);
            }
            for (String e : listOfStrings) {
                this.listOfStrings.add(e);
            }
        }

        public final Collection<StructureWithStringMember> getListOfStructs() {
            return listOfStructs;
        }

        @Override
        public final Builder listOfStructs(Collection<StructureWithStringMember> listOfStructs) {
            this.listOfStructs = ListOfStructsCopier.copy(listOfStructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfStructs(StructureWithStringMember... listOfStructs) {
            if (this.listOfStructs == null) {
                this.listOfStructs = new ArrayList<>(listOfStructs.length);
            }
            for (StructureWithStringMember e : listOfStructs) {
                this.listOfStructs.add(e);
            }
            return this;
        }

        public final void setListOfStructs(Collection<StructureWithStringMember> listOfStructs) {
            this.listOfStructs = ListOfStructsCopier.copy(listOfStructs);
        }

        @SafeVarargs
        public final void setListOfStructs(StructureWithStringMember... listOfStructs) {
            if (this.listOfStructs == null) {
                this.listOfStructs = new ArrayList<>(listOfStructs.length);
            }
            for (StructureWithStringMember e : listOfStructs) {
                this.listOfStructs.add(e);
            }
        }

        @Override
        public AllTypesStructure build() {
            return new AllTypesStructure(this);
        }
    }
}
