/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pricing.PricingAsyncClient;
import software.amazon.awssdk.services.pricing.internal.UserAgentUtils;
import software.amazon.awssdk.services.pricing.model.AttributeValue;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;

public class GetAttributeValuesPublisher
implements SdkPublisher<GetAttributeValuesResponse> {
    private final PricingAsyncClient client;
    private final GetAttributeValuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAttributeValuesPublisher(PricingAsyncClient client, GetAttributeValuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAttributeValuesPublisher(PricingAsyncClient client, GetAttributeValuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAttributeValuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAttributeValuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AttributeValue> attributeValues() {
        return this.flatMapIterable(response -> response.attributeValues());
    }

    private class GetAttributeValuesResponseFetcher
    implements AsyncPageFetcher<GetAttributeValuesResponse> {
        private GetAttributeValuesResponseFetcher() {
        }

        public boolean hasNextPage(GetAttributeValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAttributeValuesResponse> nextPage(GetAttributeValuesResponse previousPage) {
            if (previousPage == null) {
                return GetAttributeValuesPublisher.this.client.getAttributeValues(GetAttributeValuesPublisher.this.firstRequest);
            }
            return GetAttributeValuesPublisher.this.client.getAttributeValues((GetAttributeValuesRequest)((Object)GetAttributeValuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

