/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;
import software.amazon.awssdk.services.pricing.model.Service;

public class DescribeServicesIterable
implements SdkIterable<DescribeServicesResponse> {
    private final PricingClient client;
    private final DescribeServicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeServicesIterable(PricingClient client, DescribeServicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeServicesResponseFetcher();
    }

    public Iterator<DescribeServicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Service> services() {
        Function<DescribeServicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.services() != null) {
                return response.services().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeServicesResponseFetcher
    implements SyncPageFetcher<DescribeServicesResponse> {
        private DescribeServicesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeServicesResponse nextPage(DescribeServicesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServicesIterable.this.client.describeServices(DescribeServicesIterable.this.firstRequest);
            }
            return DescribeServicesIterable.this.client.describeServices((DescribeServicesRequest)((Object)DescribeServicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

