/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.pricing.model.PriceListCopier;
import software.amazon.awssdk.services.pricing.model.PricingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetProductsResponse
extends PricingResponse
implements ToCopyableBuilder<Builder, GetProductsResponse> {
    private final String formatVersion;
    private final List<String> priceList;
    private final String nextToken;

    private GetProductsResponse(BuilderImpl builder) {
        super(builder);
        this.formatVersion = builder.formatVersion;
        this.priceList = builder.priceList;
        this.nextToken = builder.nextToken;
    }

    public String formatVersion() {
        return this.formatVersion;
    }

    public List<String> priceList() {
        return this.priceList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProductsResponse)) {
            return false;
        }
        GetProductsResponse other = (GetProductsResponse)((Object)obj);
        return Objects.equals(this.formatVersion(), other.formatVersion()) && Objects.equals(this.priceList(), other.priceList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetProductsResponse").add("FormatVersion", (Object)this.formatVersion()).add("PriceList", this.priceList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FormatVersion": {
                return Optional.of(clazz.cast(this.formatVersion()));
            }
            case "PriceList": {
                return Optional.of(clazz.cast(this.priceList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PricingResponse.BuilderImpl
    implements Builder {
        private String formatVersion;
        private List<String> priceList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProductsResponse model) {
            this.formatVersion(model.formatVersion);
            this.priceList(model.priceList);
            this.nextToken(model.nextToken);
        }

        public final String getFormatVersion() {
            return this.formatVersion;
        }

        @Override
        public final Builder formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        public final void setFormatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        public final Collection<String> getPriceList() {
            return this.priceList;
        }

        @Override
        public final Builder priceList(Collection<String> priceList) {
            this.priceList = PriceListCopier.copy(priceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceList(String ... priceList) {
            this.priceList(Arrays.asList(priceList));
            return this;
        }

        public final void setPriceList(Collection<String> priceList) {
            this.priceList = PriceListCopier.copy(priceList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetProductsResponse build() {
            return new GetProductsResponse(this);
        }
    }

    public static interface Builder
    extends PricingResponse.Builder,
    CopyableBuilder<Builder, GetProductsResponse> {
        public Builder formatVersion(String var1);

        public Builder priceList(Collection<String> var1);

        public Builder priceList(String ... var1);

        public Builder nextToken(String var1);
    }
}

