/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.pricing.model.PricingResponse;
import software.amazon.awssdk.services.pricing.model.Service;
import software.amazon.awssdk.services.pricing.model.ServiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServicesResponse
extends PricingResponse
implements ToCopyableBuilder<Builder, DescribeServicesResponse> {
    private final List<Service> services;
    private final String formatVersion;
    private final String nextToken;

    private DescribeServicesResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.formatVersion = builder.formatVersion;
        this.nextToken = builder.nextToken;
    }

    public List<Service> services() {
        return this.services;
    }

    public String formatVersion() {
        return this.formatVersion;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesResponse)) {
            return false;
        }
        DescribeServicesResponse other = (DescribeServicesResponse)((Object)obj);
        return Objects.equals(this.services(), other.services()) && Objects.equals(this.formatVersion(), other.formatVersion()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeServicesResponse").add("Services", this.services()).add("FormatVersion", (Object)this.formatVersion()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Services": {
                return Optional.of(clazz.cast(this.services()));
            }
            case "FormatVersion": {
                return Optional.of(clazz.cast(this.formatVersion()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PricingResponse.BuilderImpl
    implements Builder {
        private List<Service> services;
        private String formatVersion;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesResponse model) {
            this.services(model.services);
            this.formatVersion(model.formatVersion);
            this.nextToken(model.nextToken);
        }

        public final Collection<Service.Builder> getServices() {
            return this.services != null ? (Collection)this.services.stream().map(Service::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServiceListCopier.copyFromBuilder(services);
        }

        public final String getFormatVersion() {
            return this.formatVersion;
        }

        @Override
        public final Builder formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        public final void setFormatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeServicesResponse build() {
            return new DescribeServicesResponse(this);
        }
    }

    public static interface Builder
    extends PricingResponse.Builder,
    CopyableBuilder<Builder, DescribeServicesResponse> {
        public Builder services(Collection<Service> var1);

        public Builder services(Service ... var1);

        public Builder formatVersion(String var1);

        public Builder nextToken(String var1);
    }
}

