/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pricing.model.Service;

@SdkInternalApi
public class ServiceMarshaller {
    private static final MarshallingInfo<String> SERVICECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceCode").build();
    private static final MarshallingInfo<List> ATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeNames").build();
    private static final ServiceMarshaller INSTANCE = new ServiceMarshaller();

    public static ServiceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Service service, ProtocolMarshaller protocolMarshaller) {
        if (service == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)service.serviceCode(), SERVICECODE_BINDING);
            protocolMarshaller.marshall(service.attributeNames(), ATTRIBUTENAMES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

