/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;

public final class DescribeServicesPaginator
implements SdkIterable<DescribeServicesResponse> {
    private final PricingClient client;
    private final DescribeServicesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeServicesPaginator(PricingClient client, DescribeServicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeServicesResponseFetcher();
    }

    public Iterator<DescribeServicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class DescribeServicesResponseFetcher
    implements NextPageFetcher<DescribeServicesResponse> {
        private DescribeServicesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServicesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeServicesResponse nextPage(DescribeServicesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServicesPaginator.this.client.describeServices(DescribeServicesPaginator.this.firstRequest);
            }
            return DescribeServicesPaginator.this.client.describeServices((DescribeServicesRequest)((Object)DescribeServicesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

