/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;

public final class GetProductsPaginator
implements SdkIterable<GetProductsResponse> {
    private final PricingClient client;
    private final GetProductsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetProductsPaginator(PricingClient client, GetProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetProductsResponseFetcher();
    }

    public Iterator<GetProductsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetProductsResponseFetcher
    implements NextPageFetcher<GetProductsResponse> {
        private GetProductsResponseFetcher() {
        }

        public boolean hasNextPage(GetProductsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetProductsResponse nextPage(GetProductsResponse previousPage) {
            if (previousPage == null) {
                return GetProductsPaginator.this.client.getProducts(GetProductsPaginator.this.firstRequest);
            }
            return GetProductsPaginator.this.client.getProducts((GetProductsRequest)((Object)GetProductsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

