/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;
import software.amazon.awssdk.services.pricing.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;
import software.amazon.awssdk.services.pricing.model.InternalErrorException;
import software.amazon.awssdk.services.pricing.model.InvalidNextTokenException;
import software.amazon.awssdk.services.pricing.model.InvalidParameterException;
import software.amazon.awssdk.services.pricing.model.NotFoundException;
import software.amazon.awssdk.services.pricing.model.PricingException;
import software.amazon.awssdk.services.pricing.model.PricingRequest;
import software.amazon.awssdk.services.pricing.paginators.DescribeServicesIterable;
import software.amazon.awssdk.services.pricing.paginators.GetAttributeValuesIterable;
import software.amazon.awssdk.services.pricing.paginators.GetProductsIterable;
import software.amazon.awssdk.services.pricing.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.DescribeServicesResponseUnmarshaller;
import software.amazon.awssdk.services.pricing.transform.GetAttributeValuesRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.GetAttributeValuesResponseUnmarshaller;
import software.amazon.awssdk.services.pricing.transform.GetProductsRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.GetProductsResponseUnmarshaller;

@SdkInternalApi
final class DefaultPricingClient
implements PricingClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPricingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "pricing";
    }

    @Override
    public DescribeServicesResponse describeServices(DescribeServicesRequest describeServicesRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeServicesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServicesRequest).withMarshaller((Marshaller)new DescribeServicesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeServicesIterable describeServicesPaginator(DescribeServicesRequest describeServicesRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return new DescribeServicesIterable(this, this.applyPaginatorUserAgent(describeServicesRequest));
    }

    @Override
    public GetAttributeValuesResponse getAttributeValues(GetAttributeValuesRequest getAttributeValuesRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAttributeValuesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetAttributeValuesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAttributeValuesRequest).withMarshaller((Marshaller)new GetAttributeValuesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetAttributeValuesIterable getAttributeValuesPaginator(GetAttributeValuesRequest getAttributeValuesRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return new GetAttributeValuesIterable(this, this.applyPaginatorUserAgent(getAttributeValuesRequest));
    }

    @Override
    public GetProductsResponse getProducts(GetProductsRequest getProductsRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProductsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetProductsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getProductsRequest).withMarshaller((Marshaller)new GetProductsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetProductsIterable getProductsPaginator(GetProductsRequest getProductsRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return new GetProductsIterable(this, this.applyPaginatorUserAgent(getProductsRequest));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(PricingException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredNextTokenException").withModeledClass(ExpiredNextTokenException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends PricingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((PricingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

