/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;

public class GetProductsIterable
implements SdkIterable<GetProductsResponse> {
    private final PricingClient client;
    private final GetProductsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetProductsIterable(PricingClient client, GetProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetProductsResponseFetcher();
    }

    public Iterator<GetProductsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetProductsIterable resume(GetProductsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetProductsIterable(this.client, (GetProductsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetProductsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetProductsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetProductsResponseFetcher
    implements SyncPageFetcher<GetProductsResponse> {
        private GetProductsResponseFetcher() {
        }

        public boolean hasNextPage(GetProductsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public GetProductsResponse nextPage(GetProductsResponse previousPage) {
            if (previousPage == null) {
                return GetProductsIterable.this.client.getProducts(GetProductsIterable.this.firstRequest);
            }
            return GetProductsIterable.this.client.getProducts((GetProductsRequest)((Object)GetProductsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

