/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pricing.model.AttributeNameListCopier;
import software.amazon.awssdk.services.pricing.transform.ServiceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Service
implements StructuredPojo,
ToCopyableBuilder<Builder, Service> {
    private final String serviceCode;
    private final List<String> attributeNames;

    private Service(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.attributeNames = builder.attributeNames;
    }

    public String serviceCode() {
        return this.serviceCode;
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.attributeNames(), other.attributeNames());
    }

    public String toString() {
        return ToString.builder((String)"Service").add("ServiceCode", (Object)this.serviceCode()).add("AttributeNames", this.attributeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceCode;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.serviceCode(model.serviceCode);
            this.attributeNames(model.attributeNames);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        public Service build() {
            return new Service(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Service> {
        public Builder serviceCode(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);
    }
}

