/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TextType {
    SSML("ssml"),
    TEXT("text"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TextType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TextType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TextType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TextType> knownValues() {
        return Stream.of(TextType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

