/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.polly.DefaultPollyAsyncClient;
import software.amazon.awssdk.services.polly.DefaultPollyBaseClientBuilder;
import software.amazon.awssdk.services.polly.PollyAsyncClient;
import software.amazon.awssdk.services.polly.PollyAsyncClientBuilder;
import software.amazon.awssdk.services.polly.PollyServiceClientConfiguration;
import software.amazon.awssdk.services.polly.endpoints.PollyEndpointProvider;

@SdkInternalApi
final class DefaultPollyAsyncClientBuilder
extends DefaultPollyBaseClientBuilder<PollyAsyncClientBuilder, PollyAsyncClient>
implements PollyAsyncClientBuilder {
    DefaultPollyAsyncClientBuilder() {
    }

    @Override
    public DefaultPollyAsyncClientBuilder endpointProvider(PollyEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PollyAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPollyAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        PollyServiceClientConfiguration serviceClientConfiguration = PollyServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultPollyAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

