/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.polly.model.LexiconDescription;
import software.amazon.awssdk.services.polly.transform.LexiconAttributesUnmarshaller;

public class LexiconDescriptionUnmarshaller
implements Unmarshaller<LexiconDescription, JsonUnmarshallerContext> {
    private static final LexiconDescriptionUnmarshaller INSTANCE = new LexiconDescriptionUnmarshaller();

    public LexiconDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        LexiconDescription.Builder lexiconDescriptionBuilder = LexiconDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    lexiconDescriptionBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    lexiconDescriptionBuilder.attributes(LexiconAttributesUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (LexiconDescription)lexiconDescriptionBuilder.build();
    }

    public static LexiconDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

