/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.core.sync.ResponseBytes;
import software.amazon.awssdk.core.sync.ResponseInputStream;
import software.amazon.awssdk.core.sync.StreamingResponseHandler;
import software.amazon.awssdk.services.polly.DefaultPollyClientBuilder;
import software.amazon.awssdk.services.polly.PollyClientBuilder;
import software.amazon.awssdk.services.polly.model.DeleteLexiconRequest;
import software.amazon.awssdk.services.polly.model.DeleteLexiconResponse;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.GetLexiconRequest;
import software.amazon.awssdk.services.polly.model.GetLexiconResponse;
import software.amazon.awssdk.services.polly.model.InvalidLexiconException;
import software.amazon.awssdk.services.polly.model.InvalidNextTokenException;
import software.amazon.awssdk.services.polly.model.InvalidSampleRateException;
import software.amazon.awssdk.services.polly.model.InvalidSsmlException;
import software.amazon.awssdk.services.polly.model.LexiconNotFoundException;
import software.amazon.awssdk.services.polly.model.LexiconSizeExceededException;
import software.amazon.awssdk.services.polly.model.ListLexiconsRequest;
import software.amazon.awssdk.services.polly.model.ListLexiconsResponse;
import software.amazon.awssdk.services.polly.model.MarksNotSupportedForFormatException;
import software.amazon.awssdk.services.polly.model.MaxLexemeLengthExceededException;
import software.amazon.awssdk.services.polly.model.MaxLexiconsNumberExceededException;
import software.amazon.awssdk.services.polly.model.PollyException;
import software.amazon.awssdk.services.polly.model.PutLexiconRequest;
import software.amazon.awssdk.services.polly.model.PutLexiconResponse;
import software.amazon.awssdk.services.polly.model.ServiceFailureException;
import software.amazon.awssdk.services.polly.model.SsmlMarksNotSupportedForTextTypeException;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse;
import software.amazon.awssdk.services.polly.model.TextLengthExceededException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsAlphabetException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsLanguageException;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface PollyClient
extends SdkClient,
SdkAutoCloseable {
    public static final String SERVICE_NAME = "polly";

    public static PollyClient create() {
        return (PollyClient)PollyClient.builder().build();
    }

    public static PollyClientBuilder builder() {
        return new DefaultPollyClientBuilder();
    }

    default public DeleteLexiconResponse deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public DeleteLexiconResponse deleteLexicon(Consumer<DeleteLexiconRequest.Builder> deleteLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        return this.deleteLexicon((DeleteLexiconRequest)((Object)((DeleteLexiconRequest.Builder)DeleteLexiconRequest.builder().apply(deleteLexiconRequest)).build()));
    }

    default public DescribeVoicesResponse describeVoices() throws InvalidNextTokenException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        return this.describeVoices((DescribeVoicesRequest)((Object)DescribeVoicesRequest.builder().build()));
    }

    default public DescribeVoicesResponse describeVoices(DescribeVoicesRequest describeVoicesRequest) throws InvalidNextTokenException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public DescribeVoicesResponse describeVoices(Consumer<DescribeVoicesRequest.Builder> describeVoicesRequest) throws InvalidNextTokenException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        return this.describeVoices((DescribeVoicesRequest)((Object)((DescribeVoicesRequest.Builder)DescribeVoicesRequest.builder().apply(describeVoicesRequest)).build()));
    }

    default public GetLexiconResponse getLexicon(GetLexiconRequest getLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public GetLexiconResponse getLexicon(Consumer<GetLexiconRequest.Builder> getLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        return this.getLexicon((GetLexiconRequest)((Object)((GetLexiconRequest.Builder)GetLexiconRequest.builder().apply(getLexiconRequest)).build()));
    }

    default public ListLexiconsResponse listLexicons() throws InvalidNextTokenException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        return this.listLexicons((ListLexiconsRequest)((Object)ListLexiconsRequest.builder().build()));
    }

    default public ListLexiconsResponse listLexicons(ListLexiconsRequest listLexiconsRequest) throws InvalidNextTokenException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public ListLexiconsResponse listLexicons(Consumer<ListLexiconsRequest.Builder> listLexiconsRequest) throws InvalidNextTokenException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        return this.listLexicons((ListLexiconsRequest)((Object)((ListLexiconsRequest.Builder)ListLexiconsRequest.builder().apply(listLexiconsRequest)).build()));
    }

    default public PutLexiconResponse putLexicon(PutLexiconRequest putLexiconRequest) throws InvalidLexiconException, UnsupportedPlsAlphabetException, UnsupportedPlsLanguageException, LexiconSizeExceededException, MaxLexemeLengthExceededException, MaxLexiconsNumberExceededException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public PutLexiconResponse putLexicon(Consumer<PutLexiconRequest.Builder> putLexiconRequest) throws InvalidLexiconException, UnsupportedPlsAlphabetException, UnsupportedPlsLanguageException, LexiconSizeExceededException, MaxLexemeLengthExceededException, MaxLexiconsNumberExceededException, ServiceFailureException, SdkServiceException, SdkClientException, PollyException {
        return this.putLexicon((PutLexiconRequest)((Object)((PutLexiconRequest.Builder)PutLexiconRequest.builder().apply(putLexiconRequest)).build()));
    }

    default public <ReturnT> ReturnT synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, StreamingResponseHandler<SynthesizeSpeechResponse, ReturnT> streamingResponseHandler) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, SdkServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public SynthesizeSpeechResponse synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, Path filePath) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, SdkServiceException, SdkClientException, PollyException {
        return (SynthesizeSpeechResponse)((Object)this.synthesizeSpeech(synthesizeSpeechRequest, StreamingResponseHandler.toFile((Path)filePath)));
    }

    default public ResponseInputStream<SynthesizeSpeechResponse> synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, SdkServiceException, SdkClientException, PollyException {
        return (ResponseInputStream)this.synthesizeSpeech(synthesizeSpeechRequest, StreamingResponseHandler.toInputStream());
    }

    default public ResponseBytes<SynthesizeSpeechResponse> synthesizeSpeechBytes(SynthesizeSpeechRequest synthesizeSpeechRequest) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, SdkServiceException, SdkClientException, PollyException {
        return (ResponseBytes)this.synthesizeSpeech(synthesizeSpeechRequest, StreamingResponseHandler.toBytes());
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

