/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.polly.model.LexiconAttributes;

public class LexiconAttributesUnmarshaller
implements Unmarshaller<LexiconAttributes, JsonUnmarshallerContext> {
    private static LexiconAttributesUnmarshaller INSTANCE;

    public LexiconAttributes unmarshall(JsonUnmarshallerContext context) throws Exception {
        LexiconAttributes.Builder lexiconAttributesBuilder = LexiconAttributes.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Alphabet", targetDepth)) {
                    context.nextToken();
                    lexiconAttributesBuilder.alphabet((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LanguageCode", targetDepth)) {
                    context.nextToken();
                    lexiconAttributesBuilder.languageCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModified", targetDepth)) {
                    context.nextToken();
                    lexiconAttributesBuilder.lastModified((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LexiconArn", targetDepth)) {
                    context.nextToken();
                    lexiconAttributesBuilder.lexiconArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LexemesCount", targetDepth)) {
                    context.nextToken();
                    lexiconAttributesBuilder.lexemesCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Size", targetDepth)) {
                    context.nextToken();
                    lexiconAttributesBuilder.size((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (LexiconAttributes)lexiconAttributesBuilder.build();
    }

    public static LexiconAttributesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LexiconAttributesUnmarshaller();
        }
        return INSTANCE;
    }
}

