/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.presign;

import java.net.URI;
import java.net.URL;
import java.util.Date;
import org.joda.time.DateTime;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.SdkClock;
import software.amazon.awssdk.auth.presign.PresignerFacade;
import software.amazon.awssdk.auth.presign.PresignerParams;
import software.amazon.awssdk.http.DefaultSdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.services.polly.presign.SynthesizeSpeechPresignRequest;

public final class PollyClientPresigners {
    private static final int SYNTHESIZE_SPEECH_DEFAULT_EXPIRATION_MINUTES = 15;
    private final URI endpoint;
    private final PresignerFacade presignerFacade;
    private final SdkClock clock;

    @SdkInternalApi
    public PollyClientPresigners(PresignerParams presignerParams) {
        this.endpoint = presignerParams.endpoint();
        this.presignerFacade = new PresignerFacade(presignerParams);
        this.clock = presignerParams.clock();
    }

    public URL getPresignedSynthesizeSpeechUrl(SynthesizeSpeechPresignRequest synthesizeSpeechPresignRequest) {
        DefaultSdkHttpFullRequest.Builder request = DefaultSdkHttpFullRequest.builder().endpoint(this.endpoint).resourcePath("/v1/speech").httpMethod(SdkHttpMethod.GET);
        this.marshallIntoRequest(synthesizeSpeechPresignRequest, (SdkHttpFullRequest.Builder)request);
        Date expirationDate = synthesizeSpeechPresignRequest.getExpirationDate() == null ? this.getDefaultExpirationDate() : synthesizeSpeechPresignRequest.getExpirationDate();
        return this.presignerFacade.presign((SdkHttpFullRequest)request.build(), RequestConfig.NO_OP, expirationDate);
    }

    private void marshallIntoRequest(SynthesizeSpeechPresignRequest synthesizeSpeechRequest, SdkHttpFullRequest.Builder request) {
        if (synthesizeSpeechRequest.getText() != null) {
            request.queryParameter("Text", synthesizeSpeechRequest.getText());
        }
        if (synthesizeSpeechRequest.getTextType() != null) {
            request.queryParameter("TextType", synthesizeSpeechRequest.getTextType());
        }
        if (synthesizeSpeechRequest.getVoiceId() != null) {
            request.queryParameter("VoiceId", synthesizeSpeechRequest.getVoiceId());
        }
        if (synthesizeSpeechRequest.getSampleRate() != null) {
            request.queryParameter("SampleRate", synthesizeSpeechRequest.getSampleRate());
        }
        if (synthesizeSpeechRequest.getOutputFormat() != null) {
            request.queryParameter("OutputFormat", synthesizeSpeechRequest.getOutputFormat());
        }
        if (synthesizeSpeechRequest.getLexiconNames() != null) {
            request.queryParameter("LexiconNames", synthesizeSpeechRequest.getLexiconNames());
        }
        if (synthesizeSpeechRequest.getSpeechMarkTypes() != null) {
            for (String speechMarkType : synthesizeSpeechRequest.getSpeechMarkTypes()) {
                request.queryParameter("SpeechMarkTypes", speechMarkType);
            }
        }
    }

    private Date getDefaultExpirationDate() {
        return new DateTime(this.clock.currentTimeMillis()).plusMinutes(15).toDate();
    }
}

