/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.polly.DefaultPollyClientBuilder;
import software.amazon.awssdk.services.polly.PollyClientBuilder;
import software.amazon.awssdk.services.polly.model.DeleteLexiconRequest;
import software.amazon.awssdk.services.polly.model.DeleteLexiconResponse;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.GetLexiconRequest;
import software.amazon.awssdk.services.polly.model.GetLexiconResponse;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.InvalidLexiconException;
import software.amazon.awssdk.services.polly.model.InvalidNextTokenException;
import software.amazon.awssdk.services.polly.model.InvalidS3BucketException;
import software.amazon.awssdk.services.polly.model.InvalidS3KeyException;
import software.amazon.awssdk.services.polly.model.InvalidSampleRateException;
import software.amazon.awssdk.services.polly.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.polly.model.InvalidSsmlException;
import software.amazon.awssdk.services.polly.model.InvalidTaskIdException;
import software.amazon.awssdk.services.polly.model.LanguageNotSupportedException;
import software.amazon.awssdk.services.polly.model.LexiconNotFoundException;
import software.amazon.awssdk.services.polly.model.LexiconSizeExceededException;
import software.amazon.awssdk.services.polly.model.ListLexiconsRequest;
import software.amazon.awssdk.services.polly.model.ListLexiconsResponse;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse;
import software.amazon.awssdk.services.polly.model.MarksNotSupportedForFormatException;
import software.amazon.awssdk.services.polly.model.MaxLexemeLengthExceededException;
import software.amazon.awssdk.services.polly.model.MaxLexiconsNumberExceededException;
import software.amazon.awssdk.services.polly.model.PollyException;
import software.amazon.awssdk.services.polly.model.PutLexiconRequest;
import software.amazon.awssdk.services.polly.model.PutLexiconResponse;
import software.amazon.awssdk.services.polly.model.ServiceFailureException;
import software.amazon.awssdk.services.polly.model.SsmlMarksNotSupportedForTextTypeException;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.SynthesisTaskNotFoundException;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse;
import software.amazon.awssdk.services.polly.model.TextLengthExceededException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsAlphabetException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsLanguageException;

public interface PollyClient
extends SdkClient {
    public static final String SERVICE_NAME = "polly";

    public static PollyClient create() {
        return (PollyClient)PollyClient.builder().build();
    }

    public static PollyClientBuilder builder() {
        return new DefaultPollyClientBuilder();
    }

    default public DeleteLexiconResponse deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public DeleteLexiconResponse deleteLexicon(Consumer<DeleteLexiconRequest.Builder> deleteLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return this.deleteLexicon((DeleteLexiconRequest)((Object)((DeleteLexiconRequest.Builder)DeleteLexiconRequest.builder().applyMutation(deleteLexiconRequest)).build()));
    }

    default public DescribeVoicesResponse describeVoices() throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return this.describeVoices((DescribeVoicesRequest)((Object)DescribeVoicesRequest.builder().build()));
    }

    default public DescribeVoicesResponse describeVoices(DescribeVoicesRequest describeVoicesRequest) throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public DescribeVoicesResponse describeVoices(Consumer<DescribeVoicesRequest.Builder> describeVoicesRequest) throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return this.describeVoices((DescribeVoicesRequest)((Object)((DescribeVoicesRequest.Builder)DescribeVoicesRequest.builder().applyMutation(describeVoicesRequest)).build()));
    }

    default public GetLexiconResponse getLexicon(GetLexiconRequest getLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public GetLexiconResponse getLexicon(Consumer<GetLexiconRequest.Builder> getLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return this.getLexicon((GetLexiconRequest)((Object)((GetLexiconRequest.Builder)GetLexiconRequest.builder().applyMutation(getLexiconRequest)).build()));
    }

    default public GetSpeechSynthesisTaskResponse getSpeechSynthesisTask(GetSpeechSynthesisTaskRequest getSpeechSynthesisTaskRequest) throws InvalidTaskIdException, ServiceFailureException, SynthesisTaskNotFoundException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public GetSpeechSynthesisTaskResponse getSpeechSynthesisTask(Consumer<GetSpeechSynthesisTaskRequest.Builder> getSpeechSynthesisTaskRequest) throws InvalidTaskIdException, ServiceFailureException, SynthesisTaskNotFoundException, AwsServiceException, SdkClientException, PollyException {
        return this.getSpeechSynthesisTask((GetSpeechSynthesisTaskRequest)((Object)((GetSpeechSynthesisTaskRequest.Builder)GetSpeechSynthesisTaskRequest.builder().applyMutation(getSpeechSynthesisTaskRequest)).build()));
    }

    default public ListLexiconsResponse listLexicons() throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return this.listLexicons((ListLexiconsRequest)((Object)ListLexiconsRequest.builder().build()));
    }

    default public ListLexiconsResponse listLexicons(ListLexiconsRequest listLexiconsRequest) throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public ListLexiconsResponse listLexicons(Consumer<ListLexiconsRequest.Builder> listLexiconsRequest) throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return this.listLexicons((ListLexiconsRequest)((Object)((ListLexiconsRequest.Builder)ListLexiconsRequest.builder().applyMutation(listLexiconsRequest)).build()));
    }

    default public ListSpeechSynthesisTasksResponse listSpeechSynthesisTasks() throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return this.listSpeechSynthesisTasks((ListSpeechSynthesisTasksRequest)((Object)ListSpeechSynthesisTasksRequest.builder().build()));
    }

    default public ListSpeechSynthesisTasksResponse listSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest listSpeechSynthesisTasksRequest) throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public ListSpeechSynthesisTasksResponse listSpeechSynthesisTasks(Consumer<ListSpeechSynthesisTasksRequest.Builder> listSpeechSynthesisTasksRequest) throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return this.listSpeechSynthesisTasks((ListSpeechSynthesisTasksRequest)((Object)((ListSpeechSynthesisTasksRequest.Builder)ListSpeechSynthesisTasksRequest.builder().applyMutation(listSpeechSynthesisTasksRequest)).build()));
    }

    default public PutLexiconResponse putLexicon(PutLexiconRequest putLexiconRequest) throws InvalidLexiconException, UnsupportedPlsAlphabetException, UnsupportedPlsLanguageException, LexiconSizeExceededException, MaxLexemeLengthExceededException, MaxLexiconsNumberExceededException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public PutLexiconResponse putLexicon(Consumer<PutLexiconRequest.Builder> putLexiconRequest) throws InvalidLexiconException, UnsupportedPlsAlphabetException, UnsupportedPlsLanguageException, LexiconSizeExceededException, MaxLexemeLengthExceededException, MaxLexiconsNumberExceededException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return this.putLexicon((PutLexiconRequest)((Object)((PutLexiconRequest.Builder)PutLexiconRequest.builder().applyMutation(putLexiconRequest)).build()));
    }

    default public StartSpeechSynthesisTaskResponse startSpeechSynthesisTask(StartSpeechSynthesisTaskRequest startSpeechSynthesisTaskRequest) throws TextLengthExceededException, InvalidS3BucketException, InvalidS3KeyException, InvalidSampleRateException, InvalidSnsTopicArnException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public StartSpeechSynthesisTaskResponse startSpeechSynthesisTask(Consumer<StartSpeechSynthesisTaskRequest.Builder> startSpeechSynthesisTaskRequest) throws TextLengthExceededException, InvalidS3BucketException, InvalidS3KeyException, InvalidSampleRateException, InvalidSnsTopicArnException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return this.startSpeechSynthesisTask((StartSpeechSynthesisTaskRequest)((Object)((StartSpeechSynthesisTaskRequest.Builder)StartSpeechSynthesisTaskRequest.builder().applyMutation(startSpeechSynthesisTaskRequest)).build()));
    }

    default public <ReturnT> ReturnT synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, ResponseTransformer<SynthesizeSpeechResponse, ReturnT> responseTransformer) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT synthesizeSpeech(Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest, ResponseTransformer<SynthesizeSpeechResponse, ReturnT> responseTransformer) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return this.synthesizeSpeech((SynthesizeSpeechRequest)((Object)((SynthesizeSpeechRequest.Builder)SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest)).build()), responseTransformer);
    }

    default public SynthesizeSpeechResponse synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, Path filePath) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return (SynthesizeSpeechResponse)((Object)this.synthesizeSpeech(synthesizeSpeechRequest, ResponseTransformer.toFile((Path)filePath)));
    }

    default public SynthesizeSpeechResponse synthesizeSpeech(Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest, Path filePath) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return this.synthesizeSpeech((SynthesizeSpeechRequest)((Object)((SynthesizeSpeechRequest.Builder)SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest)).build()), filePath);
    }

    default public ResponseInputStream<SynthesizeSpeechResponse> synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return (ResponseInputStream)this.synthesizeSpeech(synthesizeSpeechRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<SynthesizeSpeechResponse> synthesizeSpeech(Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return this.synthesizeSpeech((SynthesizeSpeechRequest)((Object)((SynthesizeSpeechRequest.Builder)SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest)).build()));
    }

    default public ResponseBytes<SynthesizeSpeechResponse> synthesizeSpeechAsBytes(SynthesizeSpeechRequest synthesizeSpeechRequest) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return (ResponseBytes)this.synthesizeSpeech(synthesizeSpeechRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<SynthesizeSpeechResponse> synthesizeSpeechAsBytes(Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return this.synthesizeSpeechAsBytes((SynthesizeSpeechRequest)((Object)((SynthesizeSpeechRequest.Builder)SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

